<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkCheckbox.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 复选框控件
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkCheckbox extends JCAT_UICtrlFormGtkBase
{
	/**
	 * 根据窗体ID 创建一个Gtk窗体		
	 *
	 * @access	public
	 * @param	$sWidgetId		string
	 * @static
	 * @return	GtkWidget
	 */
	static public function CreateWidget($sWidgetId)
	{
		$wndWidget = new GtkCheckButton() ;
		$wndWidget->set_name($sWidgetId) ;
		
		return $wndWidget ;
	}

	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$Value		mixed	what's this
	 * @return	old_value
	 */
	public function SetActiveValue( $Value )
	{		
		$old_value = $this->Value ;
		$this->Value = $Value ;
		return $old_value ;
	}
		
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$Value		mixed	what's this
	 * @return	void
	 */
	public function SetActiveValueByLabel()
	{
		$wndMainWidget = $this->GetMainWidget() ;
		$this->SetActiveValue($wndMainWidget->get_label()) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Value	array,mixed	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $Value )
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkCheckButton',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$wndMainWidget->set_active( $Value===$this->Value ) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	mixed, null
	 */
	public function GetExchangeData()
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkCheckButton',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;

		return $wndMainWidget->get_active()? $this->Value: $this->UnactiveValue ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkCheckButton',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		return $wndMainWidget->get_active()? 1: 0 ;
	}
		
	/**
	 * 设置一个Gtk窗体，将 UI控件 和 Gtk窗体 绑定
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkCheckButton	控件主窗体
	 * @return	old_value
	 */
	protected function SetMainWidget(GtkCheckButton $wndMainWidget=null) 
	{		
		// 设置 新的 主窗体
		$wndRet = JCAT_UICtrlGtkBase::SetMainWidget($wndMainWidget) ;
		return $wndRet ;
	}

	/**
	 * 设置选中状态
	 *
	 * @access	public
	 * @param	$bActive=true	bool
	 * @return	old_value
	 */
	public function SetActive($bActive=true)
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkCheckButton',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$old_value = $wndMainWidget->get_active() ;
		$wndMainWidget->set_active($bActive) ;
		return $old_value ;
	}


	/**
	 * 设置未选中时的值
	 *
	 * @access	public
	 * @param	$UnactiveValue		mixed	UnactiveValue
	 * @return	old_value
	 */
	public function SetUnactiveValue($UnactiveValue)
	{
		$old_value = $this->UnactiveValue ;
		$this->UnactiveValue = $UnactiveValue ;
		return $old_value ;
	}
	
	/**
	 * 取得未选中时的值
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function GetUnactiveValue()
	{
		return $this->UnactiveValue ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $Value = 1 ;

	private $UnactiveValue = null ;

	private $bAutoSetValueForLabel = true ;

	
}
?>