<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkFSChooser.php 1843 2009-05-19 13:17:03Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkFSChooser extends JCAT_UICtrlFormGtkBase implements JCAT_IUICtrlGtkCustom
{
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName				string					控件名称
	 * @param	$sUIName			string					控件UI名称
	 * @param	$Widget				GtkHBox				控件主窗体 或 主窗体ID
	 * @return	void
	 */
	public function JCAT_UICtrlGtkFSChooser( $sName, $sUIName, GtkHBox $wndWidget )
	{
		$wndMainWidget = self::CreateMainWidget() ;
		$wndMainWidget->set_name($sName) ;
		
		$wndWidget->add($wndMainWidget) ;
		
		$this->JCAT_UICtrlGtkBase($sName,$sUIName,$wndMainWidget) ;
	}

	/**
	 * 创建主窗体
	 * 
	 * @access	public
	 * @param 	$sWidgetId	string		窗体ID
	 * @static
	 * @return	GtkWidget
	 */
	static public function CreateMainWidget()
	{		
		$aUI = new JCAT_UIGtkGlade() ;
		$wndMainWidget = $aUI->Create( dirname(__FILE__).'/Template/template.JCAT_UICtrlGtkFSChooser.glade' ,'JCAT_UICtrlGtkFSChooser') ;

		// 设置 可否 手工输入
		$wndEntPath = self::GetPathEntry($wndMainWidget) ;
		$wndEntPath->set_editable( true ) ;
		
		return $wndMainWidget ;
	}

	/**
	 * 对父类的重载版本
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkCheckButton	控件主窗体
	 * @return	
	 */
	protected function SetMainWidget(GtkWidget $wndMainWidget=null) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,self::MAIN_WIDGET_CLASS) ;
		
		// 断开旧窗体中的 事件连接
		// $this->DisconnectUICtrlChanged() ;
		
		// 设置 新的 主窗体
		$wndRet = JCAT_UICtrlGtkBase::SetMainWidget($wndMainWidget) ;

		// 连接事件
		// ---------------------------------
		// 地址
		$wndEntPath = self::GetPathEntry($wndMainWidget) ;
		// $this->ConnectUICtrlChanged($wndEntPath,'changed') ;
		
		// 按钮
		$aCreator = JCAT_UIGtkGlade::GetWidgetCreator($wndMainWidget) ;
		$wndBtnBrowse = $aCreator->GetWidget('BtnBrowse') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndBtnBrowse,'GtkButton') ;
		$wndBtnBrowse->connect('clicked',array($this,'OnChoose')) ;

		return $wndRet ;
	}
	
	/**
	 * 取回子窗体
	 * 
	 * @access	public
	 * @param 	$sWidgetId	string		窗体ID
	 * @return	GtkWidget
	 */
	public function GetChildWidget( $sWidgetId )
	{
		$wndWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,self::MAIN_WIDGET_CLASS,JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$aCreator = $wndWidget->get_data('creator') ;
		return $aCreator->GetWidget($sWidgetId) ;
	}
	
	
	
	/**
	 * 弹出文件选取窗口
	 * 
	 * @access	public
	 * @param	$wndButton		GtkButton		按钮窗体
	 * @return	void
	 */
	public function OnChoose(GtkButton $wndButton)
	{
		// 已输入路径		
		$sOldDir = count($this->arrChoosed)?
			dirname($this->arrChoosed[0]) :
			'' ;
		  
		// 选取
		$Paths = JCAT_GtkFSDialog::Choose(
			$this->nAction ,
			$sOldDir ,
			$this->sFilterString ,
			$this->bMultiple ,
			$this->sTitle
		) ;
		
		// 取消
		if( $Paths===null )
			return ;
		
		$this->SetPath($Paths) ;
	}
	
	
	protected function OnEntPathChanged(GtkEntry $wndEntry)
	{
		$this->SetPath($wndEntry->get_text(),false) ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$Path		array,string		
	 * @return	array
	 */
	public function SetPath( $Path, $bUpdateWnd=true )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Path,array('string','array:string'));
		if( is_string($Path) )
		{
			$arrPaths = array($Path) ; 
		}
		else
		{
			$arrPaths = $Path ;
		}
			
		$wndEntPath = $this->GetChildWidget('EntPath') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndEntPath,'GtkEntry') ;
		
		// 保存内容
		$this->arrChoosed = $arrPaths ;
		
		// 更新窗口
		if($bUpdateWnd)
		{
			// 多选 
			if( $this->GetMultiple() )
			{
				foreach($arrPaths as &$sItem)
				{
					$sItem = "\"{$sItem}\"" ;
				}
				$sTxt = implode(', ',$arrPaths) ;
			}
			
			// 单选
			else
			{
				$sTxt = $arrPaths[0] ;
			}
				
			$wndEntPath->set_text( $sTxt ) ;
		}
	}
	
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Value	array:string, string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $Value ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Value,array('string','array:string'));
		
		if( is_string($Value) )
			$arrPath = explode($this->sSparator,$Value) ;
		else
			$arrPath =& $Value ;
			
		$this->SetPath(&$arrPath) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param 	$bString=false bool	以字符串格式返回
	 * @return	array, string
	 */
	public function GetExchangeData( $bString=false ) 
	{
		return $bString? 
				implode($this->sSparator,$this->arrChoosed) :
				$this->arrChoosed ;
	}

	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		return count($this->arrChoosed) ;
	}
	
	
	public function SetAction($nAction)
	{
		$old_value = $this->nAction ;
		$this->nAction = $nAction ;
		return $this->nAction ;
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$bMultiple=true		bool			what's this
	 * @return	void
	 */
	public function SetMultiple($bMultiple=true)
	{
		$this->bMultiple = $bMultiple? true: false ;

		// 设置 可否 手工输入
		$wndMainWidget = $this->GetMainWidget() ;
		if($wndMainWidget)
		{
			$wndEntPath = self::GetPathEntry($wndMainWidget) ;
			$wndEntPath->set_editable( !$this->GetMultiple() ) ;
		}
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function GetMultiple()
	{
		return $this->bMultiple ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	protected
	 * @param	$wndMainWidget	GtkWidget		what's this
	 * @static
	 * @return	void
	 */
	static public function GetPathEntry(GtkWidget $wndMainWidget)
	{
		$aCreator = JCAT_UIGtkGlade::GetWidgetCreator($wndMainWidget) ;
		$wndEntPath = $aCreator->GetWidget('EntPath') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndEntPath,'GtkEntry') ;
		
		return $wndEntPath ;
	}
	
	// 属性 /////////////////////////////////
	
	const MAIN_WIDGET_CLASS = 'GtkHBox' ;
	
	
	/**
	 * 选择方式
	 *
	 * @access	private
	 * @var		int
	 */
	private $nAction = Gtk::FILE_CHOOSER_ACTION_OPEN ;
	
	/**
	 * 缺省路径
	 *
	 * @access	private
	 * @var		string
	 */
	private $sDefaultPath ;
	
	/**
	 * 过滤器 字符串
	 *
	 * @access	private
	 * @var		string
	 */
	private $sFilterString ;
	
	/**
	 * 是否多选
	 *
	 * @access	private
	 * @var		bool
	 */
	private $bMultiple = false ;
	
	/**
	 * 选择窗口标题
	 *
	 * @access	private
	 * @var		string
	 */
	private $sTitle = null ;
	
	
	/**
	 * 选择的文件系统对象
	 *
	 * @access	private
	 * @var		array:string
	 */
	private $arrChoosed = array() ;
	
	/**
	 * 返回数据时 的分隔符
	 *
	 * @access	private
	 * @var		array:string
	 */
	private $sSparator = "\r\n" ;
	
}


?>