<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkGroup.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkGroup extends JCAT_UICtrlFormGtkBase implements JCAT_IUICtrlContainer
{

	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName				string		控件名称
	 * @param	$sUIName			string		控件UI名称
	 * @param	$sMainWidgetId=''	string		控件主窗体ID
	 * @return	void
	 */
	public function JCAT_UICtrlGtkGroup( $sName, $sUIName='', $sMainWidgetId='' )
	{
		$this->JCAT_UICtrlFormGtkBase($sName, $sUIName, $sMainWidgetId) ;
		
		$this->aUICtrlContainer = new _JCAT_MVCObjectContainer('JCAT_IUICtrl') ;
	}

	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sSeparator=null		string		null表示 以 serialize 方式连接子控件的值
	 * @return	old_value
	 */
	public function SetSeparator($sSeparator=null)
	{
		$old_value = $this->sSeparator ;
		$this->sSeparator = $sSeparator ;
		return $old_value ;
	}
	
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Value		array,string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $Value )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Value,array('array','string')) ;
		
		// 数组项
		if( is_string($Value) )
		{
			if($this->sSeparator===null)
				$arrData = unserialize($Value) ;
			else
				$arrData = explode($this->sSeparator,$Value) ;
		}
		
		// 数组格式
		else
			$arrData = $Value ;
		
		// 检查数据项
		$nUICtrlCount = $this->GetUICtrlCount() ;
		$nDataCount = count($arrData) ;
		if( $nUICtrlCount!==$nDataCount )
			throw new JCAT_Exception( JCAT_Language::SentenceEx('UICtrl 数据结构不符。','JCAT',null),__macro_exception_code__) ;

		// 依次设置 子控件
		$aIterator = $this->CreateUICtrlIterator() ;
		$nIdx = 0 ;
		while( !$aIterator->IsDone() )
		{
			$aUICtrl = $aIterator->Current() ;
			
			$aUICtrl->SetDataByExchange($arrData[$nIdx++]) ;		
			
			$aIterator->Next() ;
		}
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param 	$bString	string	将所有 字符串
	 * @return	string
	 */
	public function GetExchangeData( $bString=true )
	{
		$arrData = array() ;
	
		// 组装 所有 子控件 数据数组
		$aIterator = $this->CreateUICtrlIterator() ;
		while( !$aIterator->IsDone() )
		{
			$aUICtrl = $aIterator->Current() ;
			
			$arrData[] = $aUICtrl->GetExchangeData() ;
			
			$aIterator->Next() ;
		}

		// 
		if( $bString )
		{
			if($this->sSeparator===null)
				return serialize($arrData) ;
			else
				return implode($this->sSeparator,$arrData) ;
		}
		
		else
			return $arrData ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		$nLen = 0 ;
		
		// 检查 所有 子控件 数据数组
		$aIterator = $this->CreateUICtrlIterator() ;
		while( !$aIterator->IsDone() )
		{
			$aUICtrl = $aIterator->Current() ;
			
			if( $aUICtrl->VerifyData() )
				$nLen ++ ;
			
			$aIterator->Next() ;
		}
		
		return $nLen ;
	}
	
	
	/**
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @return	
	 */
	protected function SetMainWidget() 
	{
		throw new JCAT_Exception(JCAT_Language::SentenceEx('JCAT_UICtrlGtkGroup::SetMainWidget() 仅仅因为派生而存在，没有实际调用意义。','JCAT',null)) ;
	}




	///////// 实现 JCAT_IUICtrlContainer 接口 ///////////////////////////////////////////////////////////////////////////////
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUICtrl	JCAT_IUIGtkCtrl		What's this Parameter ?
	 * @return	void
	 */
	public function AddUICtrl( JCAT_IUICtrl $aUICtrl )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aUICtrl,'JCAT_IUIGtkCtrl') ;
		return $this->aUICtrlContainer->Add($aUICtrl) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	
	 */
	public function GetUICtrl( $sName )
	{ return $this->aUICtrlContainer->Get($sName) ; }

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetUICtrlCount(  ) 
	{ return $this->aUICtrlContainer->GetObjectCount() ; }

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearUICtrl(  )
	{ return $this->aUICtrlContainer->ClearObject() ; }

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateUICtrlIterator(  )
	{ return $this->aUICtrlContainer->CreateObjectIterator() ; }

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateUICtrlMemento(  )
	{ return $this->aUICtrlContainer->CreateObjectMemento() ; }

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrMemento	array	What's this Parameter ?
	 * @return	void
	 */
	public function SetUICtrlMemento( array $arrMemento )
	{ return $this->aUICtrlContainer->SetObjectMemento($arrMemento) ; }


	// 属性 ///////////////////////////////////////////////////////////////////////////////


	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		_JCAT_MVCObjectContainer
	 */
	private $aUICtrlContainer ;
	
	
	private $sSeparator = ',' ;
}


?>