<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkMText.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkMText extends JCAT_UICtrlFormGtkBase
{
	/**
	 * 根据窗体ID 创建一个Gtk窗体		
	 *
	 * @access	public
	 * @param	$sWidgetId		string
	 * @return	GtkWidget
	 */
	static public  function CreateWidget($sWidgetId)
	{
		$aBuffer = new GtkTextBuffer() ;
		$wndWidget = new GtkTextView($aBuffer) ;
		$wndWidget->set_name($sWidgetId) ;
		
		return $wndWidget ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	GtkTextBuffer, null
	 */
	public function GetGtkModel() 
	{
		$aWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aWidget,'GtkTextView',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		return $aWidget->get_buffer() ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetGtkModel( GtkTextBuffer $aModel ) 
	{
		$wndWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,'GtkTextView',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$old_value = $wndWidget->get_buffer() ;
		$aWidget->set_buffer($aModel) ;
		
		return $old_value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $sValue )
	{		
		$aModel = $this->GetGtkModel() ;
		if( !$aModel )
		{
			return null ; 
		}
		
		// 原有内容
		$sOldValue = $aModel->get_text(
				$aModel->get_start_iter()
				, $aModel->get_end_iter()
			) ;

		// 清空原有内容
		$aModel->set_text('') ;
		
		// 加入
		$this->AppendValue($sValue);
		
		// 返回原有内容
		return $sOldValue ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sValue
	 * @return	void
	 */
	public function AppendValue($sValue)
	{
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		$aModel = $this->GetGtkModel() ;
		
		// 整理图像
		// -----------------------------------	
		$nStringIndex = 0 ;	
		$arrResult = array() ;
		$sRegExp = '/<img.+?src=([\'"]?([^\'"]+)[\'"]?|([^ ]+)).*?\/?>/is' ;
		if( preg_match_all($sRegExp,$sValue,$arrResult) )
		{
			foreach ($arrResult[0] as $nResultIdx=>$sSource)
			{
				$sPath = $arrResult[1][$nResultIdx] ;
				$sPath = str_replace('"','',$sPath) ;
				$sPath = str_replace("'",'',$sPath) ;
				
				$nPos = strpos($sValue,$sSource,$nStringIndex) ;
				$nLen = strlen($sSource) ;
				
				$sBefore = substr($sValue,$nStringIndex,$nPos-$nStringIndex) ;
				$nStringIndex = $nPos+$nLen ;
				
				// 加入之前的内容
				$aModel->insert($aModel->get_end_iter(),$sBefore) ;
				
				// 插入图片
				$this->InsertImage($sPath,$aModel->get_end_iter()) ;
			}
		}
		
		// 最后一段
		$sLastSlice = substr($sValue,$nStringIndex) ;
		$aModel->insert($aModel->get_end_iter(),$sLastSlice) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetExchangeData()
	{		
		$aModel = $this->GetGtkModel() ;
		if( $aModel )
		{
			return $aModel->get_text(
				$aModel->get_start_iter()
				, $aModel->get_end_iter()
			) ;
		}
		else 
		{
			return null ;
		}
	}
	
	/**
	 * 插入图像
	 *
	 * @access	public
	 * @param 	$sImagePath	string
	 * @param 	$aPos			GtkTextIter
	 * @return	GtkTextChildAnchor
	 */
	public function InsertImage( $sImagePath, GtkTextIter $aPos )
	{
		if( !is_file($sImagePath) )
		{
			return null ;
		}
	
        try{
        	$aImage = GtkImage::new_from_file($sImagePath);
        }
        catch (Exception $aException)
        {
        	return null ;
        }

		$aModel = $this->GetGtkModel() ;
		$wndView = $this->GetMainWidget() ;
		
        $aAnchor = $aModel->create_child_anchor($aPos);
        $wndView->add_child_at_anchor($aImage, $aAnchor);
        $aImage->show() ;
        
        return $aAnchor ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		$sBuffer = $this->GetExchangeData() ;
		return strlen($sBuffer) ;
	}
	
	
	/**
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkTextView	控件主窗体
	 * @return	
	 */
	protected function SetMainWidget(GtkTextView $wndMainWidget=null) 
	{
		// 设置 新的 主窗体
		$wndRet = parent::SetMainWidget($wndMainWidget) ;

		return $wndRet ;
	}


	/**
	 * 此函数现在仅仅作为 SetDataByExchange 的别名
	 * 
	 * @access	public
	 * @param	$sText	string,null			what's this
	 * @return	old_value
	 */
	public function SetDefaultText($sText)
	{
		return $this->SetDataByExchange($sText) ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $sDefaultText = null ;

}
?>