<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkSText.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkSText extends JCAT_UICtrlFormGtkBase
{
	/**
	 * 根据窗体ID 创建一个Gtk窗体		
	 *
	 * @access	public
	 * @param	$sWidgetId		string
	 * @static
	 * @return	GtkWidget
	 */
	static public function CreateWidget($sWidgetId)
	{
		$wndEntry = new GtkEntry() ;
		$wndEntry->set_name($sWidgetId) ;
		
		return $wndEntry ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $sValue )
	{
		JCAT_ASSERT::ASSERT_STRING($sValue) ;

		$aWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aWidget,'GtkEntry',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$aWidget->set_text($sValue) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetExchangeData()
	{		
		$aWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aWidget,'GtkEntry',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$sValue = $aWidget->get_property('text') ;

		return $sValue ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetDataLength()
	{
		$sValue = $this->GetExchangeData() ;
		return strlen($sValue) ;
	}
	
	
	/**
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkEntry	控件主窗体
	 * @return	
	 */
	protected function SetMainWidget(GtkEntry $wndMainWidget=null) 
	{		
		// 设置 新的 主窗体
		return parent::SetMainWidget($wndMainWidget) ;
	}

	private $sPassword ;
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sText	string,null			what's this
	 * @return	old_value
	 */
	public function SetDefaultText($sText)
	{
		return $this->SetDataByExchange($sText) ;
	}

	/**
	 * 设置密码状态
	 *
	 * @access	public
	 * @param	$bPassword
	 * @return	old_value
	 */
	public function SetPassword($bPassword=true)
	{
		$wndEntry = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndEntry,'GtkEntry'
						, JCAT_Language::SentenceEx('控件“%s”尚未创建窗口，无法调用 GetMainWidget() 方法。','JCAT',null,$this->GetName()))  ;

		$old_value = !$wndEntry->get_visibility() ;
		$wndEntry->set_visibility(!$bPassword) ;
		return $old_value ;
	}
}
?>