<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkSelect.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkSelect extends JCAT_UICtrlFormGtkBase
{	
	/**
	 * 根据窗体ID 创建一个Gtk窗体		
	 *
	 * @access	public
	 * @param	$sWidgetId		string
	 * @static
	 * @return	GtkWidget
	 */
	static public function CreateWidget($sWidgetId)
	{
		$sClassName = $this->GetGtkWidgetClassName() ;
		$wndWidget = new $sClassName() ;
		
		// Model
		$aListStore = new GtkListStore(JCAT_Gtk_TYPE_STRING) ;
		$wndWidget->set_model($aListStore) ;
		
		// Renderer
		$aCellRenderer = new GtkCellRendererText() ;
		$wndWidget->pack_start($aCellRenderer) ;
		$wndWidget->set_attributes($aCellRenderer, 'text', 0) ;		
		
		// Widget ID
		$wndWidget->set_name($sWidgetId) ;
		
		// return
		return $wndWidget ;
	}

	/**
	 * 取得 GtkWidget 窗体类名
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function GetGtkWidgetClassName()
	{
		return 'GtkComboBox' ;		
	}

	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Value	mixed	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $Value )
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkComboBox',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$old_value = $this->GetExchangeData() ;  
		
		foreach( $this->arrOptions as $nOptionIdx=>&$arrOneOptionData )
		{
			if( $arrOneOptionData['value'] === $Value )
			{
				$wndMainWidget->set_active($nOptionIdx) ;
				break ;
			}
		}
		
		return $old_value ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	mixed, null
	 */
	public function GetExchangeData()
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkComboBox',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$nSelected = $wndMainWidget->get_active() ;
		if( $nSelected<0 )
			return null ;
		
		JCAT_ASSERT::ASSERT_( isset($this->arrOptions[$nSelected]), JCAT_Language::SentenceEx('UICtrl 的数据与窗体设置不一致。','JCAT',null) ) ;
		return $this->arrOptions[$nSelected]['value'] ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		return ($this->GetExchangeData()===null)? 0: 1 ;
	}
	
	
	/**
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkComboBox	控件主窗体
	 * @return	
	 */
	protected function SetMainWidget(GtkComboBox $wndMainWidget=null) 
	{		
		// 设置 新的 主窗体
		return JCAT_UICtrlGtkBase::SetMainWidget($wndMainWidget) ;
	}

	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	GtkListModel
	 */
	public function GetGtkModel()
	{
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkComboBox',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		return $wndMainWidget->get_model() ;		
	}
		
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sTxt				string
	 * @param	$Value=null			mxied
	 * @param	$bSelected=false	bool
	 * @return	array
	 */
	public function AddOption( $sText, $Value=null, $bSelected=false )
	{
		$this->arrOptions[] = array(
			'text' => $sText
			, 'value' => ($Value===null)? $sText: $Value
			, 'default_selected' => $bSelected? true: false
		) ;

		// 在窗体模型中 设置选项
		$wndMainWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkComboBox')  ;
		$aModel = $wndMainWidget->get_model() ;
		if($aModel)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($aModel,'GtkListStore') ;
			$aNewItem = $aModel->append( array($sText) ) ;
			
			// 选中状态
			if( $bSelected )
			{
				$wndMainWidget->set_active_iter($aNewItem) ;
			}
		}
	}


	
	/**
	 * 清除所有的 选项
	 * 
	 * @access	public
	 * @return	void
	 */
	public function ClearOptions()
	{
		$this->arrOptions = array() ;
		
		// 清除模型中的选项
		$wndMainWidget = $this->GetMainWidget() ;
		if( $wndMainWidget )
		{
			$aModel = $wndMainWidget->get_model() ;
			if($aModel)
			{
				$aModel->clear() ;
			}
		}
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	
	private $arrOptions = array() ;

}
?>