<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkSelectEntry.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlGtkSelectEntry extends JCAT_UICtrlGtkSelect
{
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName				string						控件名称
	 * @param	$sUIName			string						控件UI名称
	 * @param	$Widget	=null		GtkWidget,string,null		控件主窗体 或 主窗体ID
	 * @return	void
	 */
	public function JCAT_UICtrlGtkSelectEntry( $sName, $sUIName='', GtkComboBoxEntry $wndWidget=null )
	{
		// Model
		$aListStore = $wndWidget->get_model() ;
		if( !$aListStore )
		{
			$aListStore = new GtkListStore(JCAT_Gtk_TYPE_STRING) ;
			$wndWidget->set_model($aListStore) ;
		}

		// Renderer
		$arrChildren = $wndWidget->get_children() ;
		if( count($arrChildren)<2 )			// GtkComboBoxEntry 至少拥有两个 子窗体：下来列表 和 文本输入
		{
			$aCellRenderer = new GtkCellRendererText() ;
			$wndWidget->pack_start($aCellRenderer) ;
			$wndWidget->set_text_column(0) ;
		}
		
		// 连接事件
		$wndEntry = $wndWidget->get_child() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndEntry,'GtkEntry') ;		
		$wndWidget->connect_after('changed',array($this,'OnSelectedAfter'),$wndEntry) ;
		
		parent::__construct($sName, $sUIName, $wndWidget);
	}

	/**
	 * 根据窗体ID 创建一个Gtk窗体		
	 *
	 * @access	public
	 * @param	$sWidgetId		string
	 * @static
	 * @return	GtkWidget
	 */
	static public function CreateWidget($sWidgetId)
	{
		// 由父类 负责创建
		$wndWidget = parent::CreateWidget($sWidgetId) ;
		
		// 设置 文本列
		$wndWidget->set_text_column(0) ;
		
		// 返回
		return $wndWidget ;
	}
	
	/**
	 * 取得 GtkWidget 窗体类名
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function GetGtkWidgetClassName()
	{
		return 'GtkComboBoxEntry' ;		
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $sValue )
	{
		$wndEntry = $this->GetEntryWidget() ;
		
		$old_var = $wndEntry->get_text() ;
		$wndEntry->set_text($sValue) ;
		
		return $old_var ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetExchangeData()
	{
		$wndEntry = $this->GetEntryWidget() ;
		return $wndEntry->get_text() ;
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function GetEntryWidget()
	{
		$wndWidget = $this->GetMainWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,'GtkComboBoxEntry',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$wndEntry = $wndWidget->get_child() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndEntry,'GtkEntry') ;
		
		return $wndEntry ;
	}
	
	/**
	 * 对父类的重载版本，以便 约束具体的窗体类型
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkComboBox	控件主窗体
	 * @return	old_value
	 */
	protected function SetMainWidget(GtkComboBoxEntry $wndMainWidget=null) 
	{
		return JCAT_UICtrlGtkBase::SetMainWidget($wndMainWidget) ;
	}

	
	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		return strlen($this->GetExchangeData()) ;
	}

	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function OnSelectedAfter(GtkComboBox $wndMainWidget,GtkEntry $wndEntry)
	{
		if($this->bIngoreChangedEvent)
		{
			return ;
		}

		$Value = JCAT_UICtrlGtkSelect::GetExchangeData() ;
		if($Value===null)
		{
			return ;
		}

		$old_value = $this->bIngoreChangedEvent ;
		$this->bIngoreChangedEvent = true ;

		$wndEntry->set_text($Value) ;
		$this->bIngoreChangedEvent = $old_value ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	private $bIngoreChangedEvent = false ;
}
?>