<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ExceptionProcessorGtk.php 1837 2009-05-19 07:34:51Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_ExceptionProcessorGtk extends JCAT_Controller 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aException		JCAT_Exception
	 * @return	void
	 */
	public function JCAT_ExceptionProcessorGtk(JCAT_Exception $aException,$sViewTemplateFilename='template.JCAT_ExceptionMessageDialog.glade',$sViewWidgetId='JCAT_ExceptionMessageDialog')
	{
		$this->aException = $aException ;
		$this->JCAT_Controller(__CLASS__) ;
		
		$this->sViewTemplateFilename = $sViewTemplateFilename ;
		$this->sViewWidgetId = $sViewWidgetId ;
	}
	
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		JCAT_ASSERT::ASSERT_NOTNULL($this->aException);
		
		// 在命令行终端输出
		$aCmdProcessor = new JCAT_ExceptionProcessorCMD($this->aException) ;
		$aCmdProcessor->MainRun() ;
		
		// 使用对话框显示异常
		$aWindow = new JCAT_ViewGtk('JCAT_ExceptionProcessorGtkView',$this->sViewTemplateFilename,$this->sViewWidgetId,$this) ;
		$aWindow->Create() ;

		$aWindow->GetChildWidget('LabelExceptionKind')->set_text( get_class($this->aException) ) ;
		$aWindow->GetChildWidget('LabelExceptionCode')->set_text( $this->aException->getCode() ) ;
		$aWindow->GetChildWidget('TextExceptionMessage')->get_buffer()->set_text( $this->aException->getMessage() ) ;
		$aWindow->GetChildWidget('LabelExceptionFile')->set_text( $this->aException->getFile() ) ;
		$aWindow->GetChildWidget('LabelExceptionLine')->set_text( $this->aException->getLine() ) ;
		$aWindow->GetChildWidget('TextCallTrace')->get_buffer()->set_text( $this->aException->getTraceAsString() ) ;
		
		$aWindow->ShowView() ;
	}
	
	
	/**
	 * 被抛出的异常对象
	 * 
	 * @access	private
	 * @var		JCAT_Exception
	 */
	private $aException ;
}

?>