<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_GtkDialog.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_GtkDialog extends JCAT_ViewGtk
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName			string				视图名称
	 * @param	$sTemplateFile	string				视图模版文件
	 * @param	$sWidgetId		string				窗体ID
	 * @param	$aParent=null	JCAT_ViewGtk		拥有此视图的对象
	 * @param	$aUI=null		JCAT_UIGtkGlade		模版引擎
	 * @return	void
	 */
	public function JCAT_GtkDialog( $sName, $sTemplateFile, $sWidgetId, JCAT_IViewContainer $aParent=null, JCAT_UIGtkGlade $aUI=null ) 
	{
		$this->JCAT_ViewGtk($sName, $sTemplateFile, $sWidgetId, $aParent, $aUI) ;
	}

	/**
	 * 窗件窗体
	 *
	 * @access	public
	 * @return	GtkDialog
	 */
	public function Create()
	{
		$wndWidget = JCAT_ViewGtk::Create() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,'GtkDialog',JCAT_Language::SentenceEx('%s 的主窗体必须为有效的 GtkDialog类型 窗体。','JCAT',null,__CLASS__)) ;
		
		$wndWidget->connect( 'response', array($this,'OnResponse') ) ;

		return $wndWidget ;
	}

	public function OnResponse(GtkDialog $wndDialog, $nResponse)
	{
		switch($nResponse)
		{
			case Gtk::RESPONSE_OK :
				$this->OnOK() ;
				break ;

			case Gtk::RESPONSE_CANCEL :
				$this->OnCancel() ;
				break ;
			
			default :
				$this->Response($nResponse) ;
				break ;
		}
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$nResponse	int
	 * @return	int
	 */
	public function Response($nResponse)
	{
		JCAT_ASSERT::ASSERT_INT($nResponse) ;
		$this->nResponse = $nResponse ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetResponse()
	{
		return $this->nResponse ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param 	$bAutoDestroy=false	bool		自动销毁
	 * @return	int
	 */
	public function DoDialog( $bAutoDestroy=false ) 
	{
		// 创建/显示 对话框
		$this->ShowView() ;
		
		$wndMainWidget = $this->GetWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkDialog',JCAT_Language::SentenceEx('尚未初始化主窗体。','JCAT',null)) ;

		// 堵塞 等待 回应
		$this->Response(self::RESPONSE_NOTHING) ;
		while($this->GetResponse()==self::RESPONSE_NOTHING)
		{
			Gtk::main_iteration_do() ;
		}
		
		// 关闭对话框
		$this->ShowView(false) ;

		// 自动销毁对话框
		if($bAutoDestroy)
		{
			$wndMainWidget->destroy() ;
		}
		
		// 返回
		return $this->GetResponse() ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function OnOk() 
	{
		$this->Response(Gtk::RESPONSE_OK) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function OnCancel() 
	{
		$this->Response(Gtk::RESPONSE_CANCEL) ;
	}
	

	
	/**
	 * 设置对话框标题
	 * 
	 * @access	public
	 * @param	$sTitle		string		对话框标题
	 * @return	void
	 */
	public function SetTitle( $sTitle )
	{
		$wndMainWidget = $this->GetWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkDialog',JCAT_Language::SentenceEx('尚未初始化主窗体。','JCAT',null)) ;
		
		$wndMainWidget->set_title($sTitle) ;
	}
	
	/**
	 * 返回对话框标题
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetTitle()
	{
		$wndMainWidget = $this->GetWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMainWidget,'GtkDialog',JCAT_Language::SentenceEx('尚未初始化主窗体。','JCAT',null)) ;
		
		return $wndMainWidget->get_title() ;
	}

	
	
	
	const RESPONSE_NOTHING = 0 ;
	private $nResponse = self::RESPONSE_NOTHING ;
}
?>