<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_GtkHtmlWidget.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_GtkHtmlWidget extends GtkHtml
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_GtkHtmlWidget()
	{
		$arrArgs = func_get_args() ;
		call_user_func_array(array($this,'__construct'),$arrArgs) ;
		
		$this->connect('object-requested', array($this,'OnObjectRequested'));
	}
	
	/**
	 * 打开 Url
	 *
	 * @access	public
	 * @param	$sUrl	string
	 * @return	void
	 */
	public function Locate( $sUrl )
	{
		$sHtmlString = file_get_contents($sUrl) ;
		$this->LoadFromString($sHtmlString) ;
	}

	/**
	 * 载入 HTML
	 *
	 * @access	public
	 * @param	$sHtmlString
	 * @return	void
	 */
	public function LoadFromString($sHtmlString)
	{
		// 将 <img> 替换成 <OBJECT>
		//$sHtmlString = str_ireplace('<img ','<object ',$sHtmlString) ;
		$sRegExp = '|<img([^>]*)/?>|i' ;
		$arrResult = array() ;
		if( preg_match_all($sRegExp,$sHtmlString,$arrResult) )
		{
			foreach ($arrResult[0] as $nIdx=>$sSource)
			{
				$sHtmlString = str_replace($sSource,"<OBJECT type='image' classid=\"img:{$nIdx}{$arrResult[1][$nIdx]}\"></OBJECT>",$sHtmlString) ;
			}
		}

		// 整理所有 <OBJECT>
		$sRegExp = "|<object[^>]*></object>|i" ;
		$this->arrObjects = array() ; 
		if( preg_match_all($sRegExp,$sHtmlString,$arrResult) )
		{
			foreach ($arrResult[0] as $sSource)
			{
				$this->arrObjects[] = $sSource ;
			}
		}
		
		// 载入 修改过的 html
		$this->load_from_string($sHtmlString) ;
	}
	
	
	/**
	 * 响应 <OBJECT>载入 事件
	 *
	 * @access	public
	 * @param	$wndGtkHtml				GtkHtml
	 * @param	$wndGtkHtmlEmbedded		GtkHtmlEmbedded
	 * @return	void
	 */
	public function OnObjectRequested(GtkHtml $wndGtkHtml, $wndGtkHtmlEmbedded)
	{
		$sObjectSource = array_shift($this->arrObjects) ;
		
		$sType = strtolower( self::GetAttributeFromHTMLNode($sObjectSource,'type') ) ;
		if($sType!==null)
		{
			switch ($sType)
			{
				case 'image' :
					return $this->OnLoadImage($sObjectSource,$wndGtkHtmlEmbedded,$wndGtkHtml) ;
				
				default :            
					return false ;
			}
		}
	}
	
	/**
	 * 载入图片
	 *
	 * @access	protected
	 * @param	$sHTMLTag
	 * @param	$wndGtkHtmlEmbedded
	 * @return	void
	 */
	protected function OnLoadImage($sHTMLTag,GtkHtmlEmbedded $wndGtkHtmlEmbedded)
	{
		$sSrc = self::GetAttributeFromHTMLNode($sHTMLTag,'src') ;
		if( $sSrc===null )
		{
			return false ;
		}
		
		// 打开非 本地文件
		if( preg_match('|^http://|i',$sSrc) )
		{
			if( !$sImage = file_get_contents($sSrc) )
			{
				// 显示 红X
				// ... ...
				return false ;
			}
			
			else 
			{
				$sSrc = $this->sTempDir.time().'_'.rand(0,99999) ;
				file_put_contents($sSrc,$sImage) ;
				$bTempPath = $sSrc ;
			}
		}
		else 
		{
			$bTempPath = '' ;
		}
		
		// 图片信息
		$arrImageInfo = getimagesize($sSrc) ;
		if($arrImageInfo===false)
		{
			return false ;
		}
		
		// 载入图像
		try{
			$aBitmap = GdkPixbuf::new_from_file($sSrc) ;
		}
		catch (Exception $e)
		{$e; return false ;}
		
		// 取得图片尺寸
		$sWidth = self::GetAttributeFromHTMLNode($sHTMLTag,'width') ;
		$sHeight = self::GetAttributeFromHTMLNode($sHTMLTag,'height') ;
		$nWidth = ($sWidth===null)? $arrImageInfo[0]: intval($sWidth) ;
		$nHeight = ($sHeight===null)? $arrImageInfo[1]: intval($sHeight) ;

		// 创建 图像窗体
		$aImage = GtkImage::new_from_pixbuf($aBitmap) ;
		$wndGtkHtmlEmbedded->add($aImage) ;
        $wndGtkHtmlEmbedded->set_size_request($nWidth, $nHeight) ;
		$aImage->show() ;
		
		
		// 清除 临时文件
		if($bTempPath)
		{
			unlink($bTempPath) ;
		}
		
		return true ;
	}
	
	/**
	 * 从 HTML 节点中取得 属性值
	 *
	 * @access	public
	 * @param	$sHTMLNodeString
	 * @param	$sAttributeName
	 * @static  
	 * @return	string
	 */
	static public function GetAttributeFromHTMLNode($sHTMLNodeString,$sAttributeName)
	{
		$arrRegExps = array(
			"/{$sAttributeName}=[\"']([^\"']+)[\"']/i"			// 使用 引号
			, "/{$sAttributeName}=([^\t ]+)/i"					// 无引号
		) ;
		$arrResult = array() ;
		
		foreach ($arrRegExps as $sRegExp)
		{
			if(preg_match($sRegExp,$sHTMLNodeString,$arrResult))
			{
				return $arrResult[1] ;
			}
		}
		
		return null ;
	}
	
	// 属性 ////////////////////////////////////////////
	
	/**
	 * 在载入过程中 遇到的 <OBJECT> 标签
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrObjects = array() ;
	
	private $sTempDir = '' ;
}

?>