<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_GtkStyleSwitchMenu.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



class JCAT_GtkStyleSwitchMenu implements JCAT_IFlyweight
{
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sStyleDir		string		样式目录
	 * @param	$aMenu=null		GtkMenu		已经存在的菜单
	 * @return	void
	 */
	public function JCAT_GtkStyleSwitchMenu( $sStyleDir, $aMenu=null )
	{
		JCAT_ASSERT::ASSERT_DIR($sStyleDir) ;
		$sDir = JCAT_Global::TidyPath($sStyleDir) ;
		$this->sStyleSettingFile = $sDir.'.StyleSetting' ;
		
		$this->_ScanStyles($sDir) ;

		// 菜单
		if(!$aMenu)
			$this->aMenu = new GtkMenu() ;
		else
			$this->aMenu = $aMenu ;


		// 装载菜单 ====
		
		// 无Gtk樣式
		$this->aItemNullStyle = new GtkRadioMenuItem(null,JCAT_Language::SentenceEx('无样式','JCAT',null)) ;
		$this->aMenu->append($this->aItemNullStyle) ;
		$this->aItemNullStyle->set_active(true) ;
		$this->aItemNullStyle->connect( 'activate', array($this,'OnStyleChanging')  ) ;
		$this->aItemNullStyle->set_data('name',JCAT_Language::SentenceEx('无样式','JCAT',null)) ;
		$this->aItemNullStyle->set_data('rc','') ;

		// 可选樣式
		foreach($this->arrStyles as $sStyleName=>$sRcPath)
		{
			$aItem = new GtkRadioMenuItem($this->aItemNullStyle,$sStyleName) ;
			$this->aMenu->append($aItem) ;
			$aItem->set_data('name',$sStyleName) ;
			$aItem->set_data('rc',$sRcPath) ;
			
			// 事件
			$aItem->connect( 'activate', array($this,'OnStyleChanging')  ) ;

			// 默认项
			if( $sStyleName==$this->sDefaultStyleName )
				$aItem->set_active(true) ;
		}
		
		$this->aMenu->set_visible( true ) ;
		$this->bAlert = true ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	public function __destruct()
	{
		// 保存 设定
		$this->_SaveSetting() ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	public function OnStyleChanging( GtkMenuItem $aMenuItem )
	{
		if( !$aMenuItem->get_active() )
			return ;
			
		$sRcFile = $aMenuItem->get_data('rc') ;
		$sName = $aMenuItem->get_data('name') ;
	
		// 加载樣式		
		if( is_file($sRcFile) )
			GTK::rc_parse($sRcFile) ;
		
		if( $this->bAlert )
			JCAT_Gtk::MsgDlg( JCAT_Language::SentenceEx("样式已经切换至：“%s”。\r\n\r\n但可能要在重新启动应用程序后才会完全生效。",'JCAT',null,$sName) ) ;

		
		// 保存 设定
		$this->sDefaultStyleName = $sName ;
		$this->sDefaultStyleRcFile = $sRcFile ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStyleRC()
	{
		$this->sDefaultStyleRcFile ;
	}
	
	
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	GtkMenu
	 */
	public function GetMenu()
	{
		return $this->aMenu ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	private function _ScanStyles( $sStyleDir )
	{
		
				
		// 使用上次的 缓存结果
		if( is_file($this->sStyleSettingFile) and filemtime($this->sStyleSettingFile)>filemtime($sStyleDir) )
		{
			$arrSetting = unserialize( JCAT_Encode::Decode(file_get_contents($this->sStyleSettingFile)) ) ;

			$this->arrStyles = $arrSetting['arrStyles'] ;
			$this->sDefaultStyleName = $arrSetting['sDefaultStyleName'] ;
			$this->sDefaultStyleRcFile = $arrSetting['sDefaultStyleRcFile'] ;

			return ;
		}

		// 扫描 樣式目录
		else
		{
			$this->arrStyles = JCAT_Gtk::FindStyle($sStyleDir) ;
			$sDefaultStyleName = '' ;
			$sDefaultStyleRcFile = '' ;
		}
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	private function _SaveSetting()
	{
		$arrSetting['arrStyles'] = $this->arrStyles ;
		$arrSetting['sDefaultStyleName'] = $this->sDefaultStyleName ;
		$arrSetting['sDefaultStyleRcFile'] = $this->sDefaultStyleRcFile ;
		
		file_put_contents( $this->sStyleSettingFile, JCAT_Encode::Encode(serialize($arrSetting)) );
	}
	
	/**
	 * 同过给定参数，返回 享元实例 的 Key
	 * 
	 * @access	public
	 * @param	$Paramer1...	mixed	参数
	 * @static
	 * @return	string
	 */
	static public function GetFlyweightKey()
	{
		list($sStyleDir) = func_get_arg() ;
		return JCAT_Global::TidyPath($sStyleDir) ;
	}
	
	
	private $sStyleSettingFile ;
	
	private $arrStyles = array() ;
	
	private $sDefaultStyleName = '' ;
	
	private $sDefaultStyleRcFile = '' ;
	
	private $aItemNullStyle ;
	
	private $bAlert = false ;
	
}

JCAT_Flyweight::RegisterInstanceFactory('JCAT_GtkStyleSwitchMenu') ;

?>