<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_GtkTreeItemFilterIterator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_GtkTreeItemFilterIterator implements JCAT_IIterator
{	


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel				GtkTreeModel	What's this Parameter ?
	 * @param	$aStartItem=null	GtkTreeIter		What's this Parameter ?
	 * @param	$nLevel=0			int				What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_GtkTreeItemFilterIterator( GtkTreeModel $aModel, GtkTreeIter $aStartItem=null, $nLevel=0 ) 
	{
		$this->aTreeItemIterator = new JCAT_GtkTreeItemIterator($aModel,$aStartItem,$nLevel) ;
		$this->First() ;
	}
	
	
	public function First()
	{
		$this->aTreeItemIterator->First() ;
		
		while( !$this->aTreeItemIterator->IsDone() )
		{
			$aItem = $this->aTreeItemIterator->Current() ;

			// 遇到的第一个符合条件的 行
			if( $this->_Filter($aItem) )
				return $aItem ;
			
			$this->aTreeItemIterator->Next() ;
		}
		return null ;
	}
	
	public function Next()
	{
		if( $this->IsDone() )
			return null ;
		
		while( !$aItem = $this->aTreeItemIterator->Next() )
		{
			// 遇到的第一个符合条件的 行
			if( $this->_Filter($aItem) )
				return $aItem ;
		}

		return null ;
	}
	
	public function Current()
	{
		return $this->aTreeItemIterator->Current() ;
	}
	
	public function IsDone()
	{
		return $this->aTreeItemIterator->IsDone() ;
	}
	
	
	public function GetModel()
	{
		return $this->aTreeItemIterator->GetModel() ;
	}


	public function AddFilter( $nColumn, $Value, $bLogic=true )
	{
		JCAT_ASSERT::ASSERT_INT($nColumn) ;		

		$aModel = $this->aTreeItemIterator->GetModel() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aModel,'GtkTreeModel') ;
		JCAT_ASSERT::ASSERT_($nColumn<$aModel->get_n_columns(),JCAT_Language::SentenceEx('参数 $nColumn(=%d) 必须小于 模型的 Column数量(=%d)','JCAT',null,$nColumn,$aModel->get_n_columns())) ;
		
		$this->arrFilters[] = array(
					'column' => $nColumn ,
					'value' => $Value ,
					'logic' => $bLogic
		) ;
	}
	
	public function AddRegexpFilter( $nColumn, $sRegexp, $bLogic=true )
	{
		JCAT_ASSERT::ASSERT_INT($nColumn) ;
		JCAT_ASSERT::ASSERT_STRING($sRegexp) ;		
		
		$aModel = $this->aTreeItemIterator->GetModel() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aModel,'GtkTreeModel') ;
		JCAT_ASSERT::ASSERT_($nColumn<$aModel->get_n_columns(),JCAT_Language::SentenceEx('参数 $nColumn(=%d) 必须小于 模型的 Column数量(=%d)','JCAT',null,$nColumn,$aModel->get_n_columns())) ;
		
		$this->arrRegexpFilters[] = array(
					'column' => $nColumn ,
					'regexp' => $sRegexp ,
					'logic' => $bLogic
		) ;
	}
	
	private function _Filter( GtkTreeIter $aItem )
	{
		$aModel = $this->aTreeItemIterator->GetModel() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aModel,'GtkTreeModel') ;
		
		// 普通 过滤
		foreach($this->arrFilters as $arrOneFilter)
		{			
			JCAT_ASSERT::ASSERT_($arrOneFilter['column']<$aModel->get_n_columns(),JCAT_Language::SentenceEx('参数 $nColumn(=%d) 必须小于 模型的 Column数量(=%d)','JCAT',null,$arrOneFilter['column'],$aModel->get_n_columns())) ;
			$Value = $aModel->get_value($aItem,$arrOneFilter['column']) ;
			
			if( $arrOneFilter['logic'] and ($arrOneFilter['value']!==$Value)  )
				return false ;

			if( !$arrOneFilter['logic'] and ($arrOneFilter['value']===$Value)  )
				return false ;
		}
		
		// 正则式过滤
		foreach($this->arrRegexpFilters as $arrOneFilter)
		{
			JCAT_ASSERT::ASSERT_($arrOneFilter['column']<$aModel->get_n_columns(),JCAT_Language::SentenceEx('参数 $nColumn(=%d) 必须小于 模型的 Column数量(=%d)','JCAT',null,$arrOneFilter['column'],$aModel->get_n_columns())) ;
			$Value = $aModel->get_value($aItem,$arrOneFilter['column']) ;
			
			$bRes = preg_match($arrOneFilter['regexp'],$Value) ;
			
			if( $arrOneFilter['logic'] and $bRes  )
				return false ;

			if( !$arrOneFilter['logic'] and $bRes  )
				return false ;
		}
		
		return true ;
	}
	
	// 属性 ////////////////////////////
	
	private $aTreeItemIterator ;
	
	private $arrFilters = array() ;
	
	private $arrRegexpFilters = array() ;
	
}



?>