<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_GtkTreeItemIterator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_GtkTreeItemIterator implements JCAT_IIterator
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel				GtkTreeModel	What's this Parameter ?
	 * @param	$aStartItem=null	GtkTreeIter		What's this Parameter ?
	 * @param	$nLevel=0			int				What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_GtkTreeItemIterator( GtkTreeModel $aModel, GtkTreeIter $aStartItem=null, $nLevel=0 ) 
	{
		$this->aModel = $aModel ;
		$this->aStartItem = $aStartItem ;
		$this->nLevel = $nLevel ;
		
		$this->First() ;
	}
	
	public function First()
	{
		$this->aCurrentChildItem = $this->aModel->iter_children( $this->aStartItem ) ;
		$this->CreateChildIterator() ;

		return $this->Current() ;
	}
	
	public function Next()
	{
		if( $this->IsDone() )
		{
			return null ;
		}
		
		// 优先返回子迭代器
		$aRet = $this->aCurrentChildIterator->Next() ;
		
		// 子迭代器 已空，迭代到下一个 item
		if( $aRet===null )
		{
			$aRet = $this->aCurrentChildItem ;

			$this->aCurrentChildItem = $this->aModel->iter_next($this->aCurrentChildItem) ;
			$this->CreateChildIterator() ;
			return $aRet ;
		}

		return $aRet ;
	}
	
	public function Current()
	{
		if( !$this->aCurrentChildIterator->IsDone() )
		{
			return $this->aCurrentChildIterator->Current() ;
		}
		else
		{
			return $this->aCurrentChildItem ;
		}
	}
	
	public function IsDone()
	{
		return ($this->aCurrentChildItem===null) ;
	}
	
	private function CreateChildIterator()
	{
		if( !$this->aCurrentChildItem or $this->nLevel==self::DONT_CHILDREN )
		{
			$this->aCurrentChildIterator = new JCAT_NullIterator() ;
		}
		else 
		{
			$this->aCurrentChildIterator = new self($this->aModel,$this->aCurrentChildItem,$this->nLevel-1) ;
		}
	}
	
	
	
	/**
	 * Enter description here...
	 *
	 * @access 	public
	 * @return	GtkTreeModel
	 */
	public function GetModel()
	{
		return $this->aModel ;
	}

	
	// 属性 ////////////////////////////
	
	private $nLevel = -1 ;
	
	private $aStartItem ;
	
	private $aModel ;
	
	private $aCurrentChildItem ;
	
	private $aCurrentChildIterator ;

	// 不历遍子项
	const DONT_CHILDREN = 0 ;
	
	// 历遍所有子项
	const NO_LIMIT = -1 ;
}


?>