<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Timer.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 计时器类
 *
 * @author		alee
 * @access		public
 */
class JCAT_Timer
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_Timer( $nSec, $nMicroSec=0, $bAutoDestroy=false )
	{
		JCAT_ASSERT::ASSERT_INT($nSec) ;
		JCAT_ASSERT::ASSERT_INT($nMicroSec) ; 

		$this->nMicroSec = $nSec + ($nMicroSec/1000) ;
		$this->bAutoDestroy = $bAutoDestroy ;
		
		$this->nTimerId = self::$nAssignTimerId++ ;
		self::$arrTimers[ $this->nTimerId ] = $this ;
	}
	
	/**
	 * 创建 计时器迭 代器 
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IIterator
	 */
	static public function CreateTimerIterator()
	{		
		return new JCAT_ArrayIterator( self::$arrTimers ) ;
	}
	
	/**
	 * 取得 计时器 ID
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetTimerId()
	{
		return $this->nTimerId ;
	}

	/**
	 * 析构函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function DestroyTimer( JCAT_Timer $aTimer )
	{
		unset(self::$arrTimers[ $aTimer->GetTimerId() ]) ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		int
	 */
	static private $arrTimers = array() ;
	static private $nAssignTimerId = 0 ;
	
	
	
	/**
	 * 计时开始
	 *
	 * @access	public
	 * @param	$Callbace			callback
	 * @param	$nDoCount=1		int			执行次数
	 * @return	void
	 */
	public function Start( $Callbace, $nDoCount=1, $arrArgs=array() )
	{
		JCAT_ASSERT::ASSERT_INT($nDoCount) ;
		JCAT_ASSERT::ASSERT_($this->bDoing===false,JCAT_Language::SentenceEx('计时器已经开始，在结束前无法重复调用 Start方法。','JCAT',null)) ;

		$this->Callback = $Callbace ;
		$this->nStateTime = microtime(true) ;
		$this->nDoCount = $nDoCount ;
		$this->nDoneCount = 0 ;
		$this->arrArgs = $arrArgs ;
		
		$this->bDoing = true ;
	}

	/**
	 * 返回计时器是否在执行中	
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsDoing()
	{
		return $this->bDoing ;
	}
	
	/**
	 * 循环执行，由系统调用
	 *
	 * @access	public
	 * @return	void
	 */
	public function LoopOnce()
	{
		if( $this->nDoCount===0 )
		{
			return ;
		}
		
		if( $this->IsTimeOut() )
		{
			$this->nDoCount -- ;
			$this->nDoneCount ++ ;
			
			$this->nStateTime = microtime(true) ;
			
			call_user_func_array($this->Callback,$this->arrArgs) ;
		
			// 结束
			if( $this->nDoCount===0 )
			{
				$this->bDoing = false ;
				
				// 自动销毁
				if( $this->bAutoDestroy )
				{
					self::DestroyTimer($this) ;
				}
			}				
		}
	}
	
	/**
	 * 时间是否
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsTimeOut()
	{
		if( !$this->IsDoing() )
		{
			return false ;
		}
		
		return (microtime(true) - $this->nStateTime) >= $this->nMicroSec ;
	}
	
	/**
	 * 检查所有定时器是否被触发
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function Tick()
	{
		foreach (self::$arrTimers as $aTimer)
		{
			$aTimer->LoopOnce() ;
		}
	}
	
	// 属性 //////////////////////////////////////////
		
	/**
	 * 微秒
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nMicroSec = 0 ;
	
	/**
	 * 回调函数
	 * 
	 * @access	private
	 * @var		callback
	 */
	private $Callback ;
	
	/**
	 * 参数
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrArgs ;
	
	/**
	 * 开始时间
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nStateTime ;
	
	/**
	 * 执行次数
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nDoCount = 0 ;
	
	/**
	 * 执行次数
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nDoneCount = 0 ;

	/**
	 * 是否在执行中
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bDoing = false ;

	/**
	 * 计时器 ID
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nTimerId = -1 ;
	
	/**
	 * 自动销毁
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bAutoDestroy = false ;
	
}

?>