<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewGtk.php 2010 2009-08-31 14:19:32Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewGtk extends JCAT_View implements JCAT_IViewGtk
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sName			string				视图名称
	 * @param	$sTemplateFile	string				视图模版文件
	 * @param	$sWidgetId		string				窗体ID
	 * @param	$aParent=null	JCAT_ViewGtk		拥有此视图的对象
	 * @param	$aUI=null		JCAT_UIGtkGlade		模版引擎
	 * @return	void
	 */
	public function JCAT_ViewGtk( $sName, $sTemplateFile, $sWidgetId, JCAT_IViewContainer $aParent=null, JCAT_UIGtkGlade $aUI=null ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sTemplateFile) ;
		JCAT_ASSERT::ASSERT_STRING($sWidgetId) ;
		
		$this->sTemplateFile = $sTemplateFile ;
		$this->sWidgetId = $sWidgetId ;
		
		// 父类构造函数
		$this->JCAT_View( $sName, $aParent ) ;

		
		$this->aUI = ($aUI===null)?
						new JCAT_UIGtkGlade() :		//  为避免窗体变量混乱，不同 View 使用独立的 UI对象，而不使用享元对象
						$aUI ;
	}

	
	/**
	 * 当 UICtrl 中的数据改变时，触发此事件
	 * 
	 * @access	public
	 * @param 	$aUICtrl	JCAT_IUIGtkCtrl
	 * @return	void
	 */
	public function OnUICtrlChanged( JCAT_IUIGtkCtrl $aUICtrl )
	{
		// 自动 数据交换
		//if( $this->GetModel() )
		//{
		//	$this->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC,$aUICtrl->GetName()) ;
		//}

		// 触发 OnUpdate 事件
		$this->OnUpdate() ;
	}

	/**
	 * 取回窗体
	 *
	 * @access	public
	 * @return	GtkWidget
	 */
	public function GetWidget()
	{
		// JCAT_ASSERT::ASSERT_INSTANCE($this->wndWidget,'GtkWidget',JCAT_Language::SentenceEx('尚未 调用 Create() 方法创建窗体。','JCAT',null)) ;
		return $this->wndWidget ;
	}


	/**
	 * 设置窗体
	 *
	 * @access	public
	 * @return	old_value
	 */
	public function SetWidget( GtkWidget $aWidget )
	{
		$old_value = $this->wndWidget ;
		$this->wndWidget = $aWidget ;
		return $old_value ;
	}
	
	/**
	 * 取得创建 Gtk窗体 的 Creator 对象
	 *
	 * @access	public
	 * @return	JCAT_UIGtkWidgetCreator
	 */
	public function GetCreator()
	{
		$wndWidget = $this->GetWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,'GtkWidget',JCAT_Language::SentenceEx('尚未 调用 Create() 方法创建窗体。','JCAT',null)) ;
		
		$aWidgetCreator = $wndWidget->get_data('creator') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aWidgetCreator,'JCAT_UIGtkWidgetCreator') ;
		
		return $aWidgetCreator ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sWidgetId	string		What's this Parameter ?
	 * @return	GtkWidget
	 */
	public function GetChildWidget($sWidgetId)
	{
		JCAT_ASSERT::ASSERT_STRING($sWidgetId) ;
		
		$wndWidget = $this->GetWidget() ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndWidget,'GtkWidget',JCAT_Language::SentenceEx('尚未 调用 Create() 方法创建窗体。','JCAT',null)) ;

		$aCreator = JCAT_UIGtkGlade::GetWidgetCreator($wndWidget) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aCreator) ;
		
		
		// 可用于 响应 signal 事件的 对象
		$arrObjectForSignal['TheView'] = $this ;
		$arrObjectForSignal['TheController'] = $this->GetParentController() ;
		$arrObjectForSignal['TheModel'] = $this->GetModel() ;
		
		try
		{
			return $aCreator->GetWidget($sWidgetId,$arrObjectForSignal) ;
		}
		catch (Exception $e)
		{
			// 指定 id 的窗体不存在
			if($e->getCode()===JCAT_UIGtkWidgetCreator::EXCE_ID_NOWIDGET)
			{
				return null ;
			}
			
			// 其他异常，继续向外抛出
			else
			{
				throw $e ;
			}
		}
	}
	
	/**
	 * 取回Gtk窗体的模版引擎
	 *
	 * @access	public
	 * @return	JCAT_UIGtkGlade
	 */
	public function GetUI()
	{
		return $this->aUI ;
	}

	/**
	 * 窗件窗体
	 *
	 * @access	public
	 * @return	GtkWidget
	 */
	public function Create()
	{
		// 在创建窗口的过程中 不受 tick 的打扰
		declare(ticks=0)   
		{
			$aUI = $this->GetUI() ;
			JCAT_ASSERT::ASSERT_INSTANCE($aUI,'JCAT_UIGtkGlade') ;
	
			// 可用于 响应 signal 事件的 对象
			$arrObjectForSignal['TheView'] = $this ;
			$arrObjectForSignal['TheController'] = $this->GetParentController() ;
			$arrObjectForSignal['TheModel'] = $this->GetModel() ;
	
			// 创建窗体
			$this->wndWidget = $aUI->Create($this->sTemplateFile,$this->sWidgetId,$arrObjectForSignal) ;
			JCAT_ASSERT::ASSERT_INSTANCE($this->wndWidget,'GtkWidget');
		}
		
		return $this->wndWidget ;
	}
	
	
	
	/**
	 * 显示（或隐藏）视图
	 *
	 * @access	public
	 * @param	$bShow=true					bool	What's this Parameter ?
	 * @param	$bForAllChildren=false		bool	What's this Parameter ?
	 * @return	void
	 */
	public function ShowView( $bShow=true, $bForAllChildren=false )
	{
		$wndWidget = $this->GetWidget() ;
		$wndWidget->set_visible($bShow,$bForAllChildren) ;
	}
	
	
	
	/**
	 * 查询 视图是否改变（所属 UICtrl 是否改变）
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsChanged()
	{
		// 检查直属 UICtrl
		$aIterator = $this->CreateUICtrlIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aUICtrl = $aIterator->Current() ;
			
			if( JCAT_Global::HasImplementedTo($aUICtrl,'JCAT_IUIGtkCtrl') )
			{
				if( $aUICtrl->IsUICtrlChanged() )
				{
					return true ;
				}
			}
			
			$aIterator->Next() ;
		}
		
		// 检查 子视图
		$aIterator = $this->CreateViewIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aSubView = $aIterator->Current() ;
		
			if( JCAT_Global::HasImplementedTo($aSubView,'JCAT_IViewGtk') )
			{
				if( $aSubView->IsChanged() )
				{
					return true ;
				}
			}
			
			$aIterator->Next() ;
		}
		
		
		return false ;
	}

	/**
	 * 为窗口设置一个图像作为背景
	 *
	 * @access	public
	 * @param	$sImagePath		string
	 * @return	void
	 */
	public function SetImageBackground($sImagePath)
	{
		// 载入图像
		try 
		{
			$aPixbuf=GdkPixbuf::new_from_file($sImagePath) ;
		}
		catch (Exception $e)
		{
			print $e->getMessage() ;
			print "\r\n Image {$sImagePath} Can't load.\r\n" ;
			return ;
		}
		list($aPixmap,)=$aPixbuf-> render_pixmap_and_mask(255) ;
		
		// 将图像作为背景样式 设置给窗口
		$wndWindow = $this->GetWidget() ;
		$aStyle = $wndWindow->get_style() ;
		$aStyle = $aStyle->copy() ;
		$aStyle->bg_pixmap[Gtk::STATE_NORMAL]=$aPixmap ;
		$wndWindow->set_style($aStyle) ;
	}
	
	/**
	 * 销毁窗体
	 *
	 * @access	public
	 * @return	void
	 */
	public function DestroyWindow()
	{
		$wndWindow = $this->GetWidget() ;
		$wndWindow->destroy() ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////


	static $aShareGlobalUI ;
	
	private $sTemplateFile ;
	
	private $sWidgetId ;
	
	private $wndWidget ;

	// private $bSetDocChangedByUICtrlChanging = true ;
}
?>