<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_HtmlLayoutElementBase.php 1749 2009-04-27 17:48:00Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * ViewHtml 的 布局装饰器
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_HtmlLayoutElementBase
	extends JCAT_ViewHtml 
	implements JCAT_IHtmlLayoutElement
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_HtmlLayoutElementBase(JCAT_CSSTheme $aCCSTheme)
	{
		$this->SetCSSTheme($aCCSTheme) ;
	}
	
	const LEFT = 'left' ;
	const CENTER = 'center' ;
	const RIGHT = 'right' ;
	
	const TOP = 'top' ;
	const MIDDLE = 'middle' ;
	const BOTTON = 'bottom' ;
	
	// 实现 JCAT_IHtmlLayoutElement 的方法
	// ----------------------------------------------
	/**
	 * 设置宽度
	 *
	 * @access	public
	 * @param	$nWidth=-1			int
	 * @return	old_value
	 */
	public function SetWidth($nWidth=-1)
	{
		$old_value = $this->nWidth ;
		$this->nWidth = $nWidth ;
		return $old_value ;
	}
	
	/**
	 * 设置高度
	 *
	 * @access	public
	 * @param	$nHeight=-1			int
	 * @return	old_value
	 */
	public function SetHeight($nHeight=-1)
	{
		$old_value = $this->nHeight ;
		$this->nHeight = $nHeight ;		
		return $old_value ;
	}
	
	/**
	 * 取得宽度
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetWidth()
	{
		return $this->nWidth ;
	}
	
	/**
	 * 取得高度
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetHeight()
	{
		return $this->nHeight ;
	}

	/**
	 * 设置 是否填充
	 *
	 * @access	public
	 * @param	$bHFill=true		bool
	 * @param	$bVFill=true		bool
	 * @return	void
	 */
	public function SetFill($bHFill=true,$bVFill=true)
	{
		$this->SetWidth( $bHFill? 0: -1 ) ;
		$this->SetHeight( $bVFill? 0: -1 ) ;
	}
	
	/**
	 * 返回 水平 是否填充
	 *
	 * @access	public	
	 * @return	bool
	 */
	public function GetHFill()
	{
		return $this->GetWidth()===0 ;
	}
	
	/**
	 * 返回 垂直 是否填充
	 *
	 * @access	public	
	 * @return	bool
	 */
	public function GetVFill()
	{
		return $this->GetHeight()===0 ;
	}
	
	/**
	 * 返回 长宽 字符格式
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetSizeString()
	{
		$sRet = '' ;
		
		// 宽度
		$nWidth = $this->GetWidth() ;
		if($nWidth>0)
		{
			$sRet.= " width='{$nWidth}px'" ;
		}
		else if($nWidth==0)
		{
			$sRet.= " width='100%'" ;
		}
		
		// 高度
		$nHeight = $this->GetHeight() ;
		if($nHeight>=0)
		{
			$sRet.= " height='{$nHeight}px'" ;
		}
		else if($nHeight==0)
		{
			$sRet.= " height='100%'" ;
		}

		
		return $sRet ;
	}
	
	/**
	 * 设置对齐
	 *
	 * @access	public
	 * @param	$sHAlign	string
	 * @param	$svAlign	string
	 * @return	void
	 */
	public function SetAlign($sHAlign=self::LEFT,$svAlign=self::TOP)
	{
		$this->sHAlign = $sHAlign ;
		$this->sVAlign = $snVAlign ;
	}

	/**
	 * 返回 横向 对齐方式
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetHAlign()
	{
		return $this->sHAlign ;
	}
	
	/**
	 * 返回 纵向 对齐方式
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetVAlign()
	{
		return $this->sVAlign ;
	}
	
	
	// 属性 /////////////////////////////
		
	private $sHAlign = self::LEFT ;
	
	private $sVAlign = self::TOP ;
	
	private $nWidth = -1 ;
	
	private $nHeight = -1 ;
}

?>