<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_HtmlLayoutFrame.php 1829 2009-05-18 11:34:40Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_HtmlLayoutFrame
	extends JCAT_HtmlLayoutElementBase
{
	
	const VERTICAL = 1 ;
	const LABEL = 2 ;
	
	const HORIZONTAL = 4 ;
	const MATRIX = 8 ;
	
	const FLOAT_LEFT = 12 ;
	
	
	static private $nInstanceID = 0 ;
	
	public function JCAT_HtmlLayoutFrame(JCAT_IViewContainer $aParent,$nLayoutWay=self::VERTICAL,$sName=null,JCAT_UIHtml $aUI=null,JCAT_CSSTheme $aCCSTheme=null)
	{
		$this->nLayoutWay = $nLayoutWay ;
		
		if($sName===null)
		{
			$sName = 'JCAT_HtmlLayoutFrame_' . (++self::$nInstanceID) ;
		}
		
		if(!$aUI)
		{
			$aUI = JCAT_ViewHtml::CreateShareUI() ;
		}

		parent::JCAT_ViewHtml('template.JCAT_HtmlLayoutFrame.html',$aParent,$sName,$aUI) ;

		if(!$aCCSTheme)
		{
			$aCCSTheme = self::CreateDefaultCSSTheme($this->GetUI()) ;
		}
		parent::JCAT_HtmlLayoutElementBase($aCCSTheme) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_CSSTheme
	 */
	static public function CreateDefaultCSSTheme(JCAT_UIHtml $aUI)
	{
		$aTheme = new JCAT_CSSTheme(null,'JCAT_HtmlLayoutFrame') ;
		
		$aTheme->DefineItem(JCAT_CSSTheme::DEFAULT_ITEM) ;
		$aTheme->DefineItem('FLOATLEFT') ;
		$aTheme->DefineFile('JCAT_HtmlLayoutFrame.css',$aUI) ;
		
		return $aTheme ;
	}
	
	/**
	 * 取得布局方向
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetLayoutWay()
	{
		return $this->nLayoutWay ;
	}
	
	/**
	 * 对子视图实行布局
	 *
	 * @access	public
	 * @param	$aViews					JCAT_IViewContainer
	 * @param	$arrLayerSetting		array
	 * @return	array
	 */
	public function Layout(JCAT_IViewContainer $aViews, $arrLayerSetting)
	{
		$arrUsedViews = array() ;

		foreach ($arrLayerSetting as $arrChild)
		{
			JCAT_ASSERT::ASSERT_(isset($arrChild['Type']),JCAT_Language::SentenceEx('Layout() 传入的参数 $arrLayerSetting 缺少必要的“Type”元素，该数据可能已经被损坏。','JCAT',null))  ;
			
			if($arrChild['Type']=='view')
			{
				JCAT_ASSERT::ASSERT_(isset($arrChild['Name']),JCAT_Language::SentenceEx('Layout() 传入的参数 $arrLayerSetting 缺少必要的“Name”元素，该数据可能已经被损坏。','JCAT',null))  ;

				// 根据 视图名称 取得视图
				$aChildView = $aViews->GetView($arrChild['Name']) ;
				
				// 视图不存在 创建 缺失视图
				if(!$aChildView)
				{
					$aChildView = $this->CreateMissView($arrChild['Name']) ;
				}
				
				$arrUsedViews[] = $arrChild['Name'] ;
				
				// 是否使用布局装饰器
				if( !empty($arrChild['Decorator']) )
				{
					$aChildViewDecorator = new JCAT_ViewHtmlLayoutDecorator($aChildView->GetName(),$aChildView,$this) ;
					$this->AddView($aChildViewDecorator) ;
				}
				
				else 
				{
					$this->AddView($aChildView) ;
				}
				
			}
			
			else if($arrChild['Type']=='frame')
			{
				if( !isset($arrChild['LayoutWay']) )
				{
					$arrChild['LayoutWay'] = self::VERTICAL ;
				}
				if( !isset($arrChild['Children']) )
				{
					$arrChild['Children'] = array() ;
				}
				
				// 创建一个子视图框架 递归处理
				$aChildFrame = new JCAT_HtmlLayoutFrame($arrChild['LayoutWay'],$this) ;
				$arrChildFrameUsedViews = $aChildFrame->Layout($aViews,$arrChild['Children']) ;
				$arrUsedViews = array_merge($arrUsedViews,$arrChildFrameUsedViews);
				
				$this->AddView($aChildFrame) ;
			}
			
			else
			{
				JCAT_ASSERT::ASSERT_(0,JCAT_Language::SentenceEx('Layout() 传入的参数 $arrLayerSetting 中“Type”元素出现未知的类型：“%s”。','JCAT',null,$arrChild['Type']))  ;
			}
		}
		
		return $arrUsedViews ;		
	}

	
	/**
	 * 返回当前布局的 配置表
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetLayoutSetting()
	{
		// todo
		// ... ...
	}
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aView			JCAT_IView		What's this Parameter ?
	 * @param	$sName=null		string			What's this Parameter ?
	 * @return	void
	 */
	public function AddView( JCAT_IView $aView, $sTitle=null ) 
	{
		if( !JCAT_Global::HasImplementedTo($aView,'JCAT_IHtmlLayoutElement') )
		{
			$aView = new JCAT_ViewHtmlLayoutDecorator($sTitle,$aView) ;
		}
		
		return parent::AddView($aView, $sTitle ) ;
	}
	
	/**
	 * 创建缺失视图
	 *
	 * @access	private
	 * @param	$sName		string
	 * @return	JCAT_ViewHtml
	 */
	private function CreateMissView($sName)
	{
		return new JCAT_ViewHtml('template.JCAT_HtmlLayoutFrame.html',$this,$sName) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function GetClassName()
	{
		$TheCSSTheme = $this->GetCSSTheme() ;
		
		$arrItems = array(JCAT_CSSTheme::DEFAULT_ITEM) ;
		if($this->GetLayoutWay()&self::FLOAT_LEFT)
		{
			$arrItems[] = 'FLOATLEFT' ;
		}
		
		return $TheCSSTheme->GetClassName($arrItems) ;
	}
	// 属性 /////////////////////////////
		
	private $nLayoutWay = self::VERTICAL ;
	
}

?>