<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlLayoutDecorator.php 1752 2009-04-27 18:13:12Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * ViewHtml 的 布局装饰器
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlLayoutDecorator
	extends JCAT_HtmlLayoutElementBase
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$sTitle				string
	 * @param	$aViewComponent		JCAT_IViewHtml
	 * @param	$aParent			JCAT_IViewContainer		父视图 或 控制器
	 * @param	$aCCSTheme=null		JCAT_CSSTheme			css主题
	 * @return	void
	 */
	public function JCAT_ViewHtmlLayoutDecorator($sTitle, JCAT_IViewHtml $aViewComponent,JCAT_IViewContainer $aParent=null,JCAT_CSSTheme $aCCSTheme=null,JCAT_UI $aUI=null)
	{
		$this->sTitle = $sTitle ;
		$this->aViewComponent = $aViewComponent ;

		parent::JCAT_ViewHtml(
				'template.JCAT_ViewHtmlLayoutDecorator.html' 
				, $aParent? $aParent: $aViewComponent->GetParent()
				, 'JCAT_LayoutDecorator_'.(self::$nInstanceID++)
				, $aUI ) ;

		if(!$aCCSTheme)
		{
			$aCCSTheme = self::CreateDefaultTheme($this->GetUI()) ;
		}
		parent::JCAT_HtmlLayoutElementBase($aCCSTheme) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_CSSTheme
	 */
	static public function CreateDefaultTheme(JCAT_UIHtml $aUI)
	{
		$aTheme = new JCAT_CSSTheme(null,'JCAT_ViewHtmlLayoutDecorator') ;

		$aTheme->DefineItem(JCAT_CSSTheme::DEFAULT_ITEM) ;
		$aTheme->DefineItem('TitleDiv') ;
		$aTheme->DefineItem('ComponentViewDiv') ;

		$aTheme->DefineFile('JCAT_HtmlLayoutFrame.css',$aUI) ;
		
		return $aTheme ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassName()
	{
		// $this->GetLayout
	}
	
	/**
	 * 显示组件视图
	 *
	 * @access	public
	 * @return	void
	 */
	public function ShowComponentView()
	{
		$this->aViewComponent->ShowView() ;
	}

	/**
	 * 设置标题
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetTitle($sTitle)
	{
		return $this->sTitle = $sTitle ;
	}
	
	/**
	 * 返回标题
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTitle()
	{
		return $this->sTitle ;
	}
	
	
	// 实现 JCAT_IView 的方法
	// ----------------------------------------------

	public function SetName( $sName )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function SetModel( JCAT_IModel $aModel )
	{
		
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function GetModel(  )
	{
		
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function Update()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function Destroy()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}
	
	
	
	
	// 实现 JCAT_IViewContainer 的方法
	// ----------------------------------------------

	public function AddView( JCAT_IView $aViewComponent, $sName=null )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function RemoveView( $ViewComponent )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function GetView( $sName, $bRecursion=false )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function GetViewCount(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function ClearView(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function CreateViewIterator(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function CreateViewMemento(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function SetViewMemento( $arrMemento )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	
	// 实现 JCAT_IUICtrlContainer 的方法
	// ----------------------------------------------
	
	public function AddUICtrl( JCAT_IUICtrl $aUICtrl )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function GetUICtrl( $sName )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function GetUICtrlCount(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function ClearUICtrl(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	public function CreateUICtrlIterator(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}
	
	public function CreateUICtrlMemento(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}
	
	public function SetUICtrlMemento( array $arrMemento )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aViewComponent,__FUNCTION__),$arrArgs) ;
	}

	
	
	// 属性 ///////////////////////////////////////////
		
	private $sTitle ;
	
	private $aViewComponent ;
	
	static private $nInstanceID = 0 ;
	
}

?>