<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlNodeCompiler_Form.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlNodeCompiler_Form extends JCAT_UIHtmlNodeCompilerBase
{

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{ return false ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		// 检查参数
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIHtmlNode') ;
		// $this->VerifyNode($aObject) ;
		
		// 节点属性
		$aAttribute = $aObject->GetAttribute() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		$sAttributeSource = $aAttribute->GetSource() ;
		
		// 条件 体
		$aBody = $aObject->GetBody() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aBody,'JCAT_UIHtmlObject') ;
		$sBody = $aBody->GetCompiled() ;
		
		if( $aAttribute->GetAttribute('native') )
		{
			$sCompiled = "<form {$sAttributeSource}>{$sBody}</form>" ;			
		}

		else 
		{
			$sCompiled = "
<form {$sAttributeSource} name='<?php if(JCAT_Global::IsKindOf(\$TheView,'JCAT_ViewHtmlForm'))print \$TheView->GetFormName() ;?>'>{$sBody}
	<?php if(JCAT_Global::IsKindOf(\$TheView,'JCAT_ViewHtmlForm'))print \$TheView->GetFormSubmitSign() ;?>
</form>" ;
		}


		$aObject->SetCompiled($sCompiled) ;
		
		return $sCompiled ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aGlobalManager->RegisterProcessor( 'form', __CLASS__ ) ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>