<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlNodeCompiler_Model_Data.php 1885 2009-06-01 15:34:32Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlNodeCompiler_Model_Data extends JCAT_UIHtmlNodeCompilerBase
{

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{ return false ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIHtmlNode') ;

		$aBody = $aObject->GetBody() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aBody,'JCAT_UIHtmlObject') ;
			
		$sDataName = trim($aBody->GetCompiled()) ;
		$sTemplateFile = basename($aObject->GetTemplateFile()) ;
		
		$sExp = "\$TheModel->Get('{$sDataName}')" ;
		
		
		// html 属性
		/*$aAttribute = $aObject->GetAttribute() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		$bHtml = $aAttribute->GetAttribute('html') ;
		if($bHtml===null)
		{
			$bHtml = 'false' ;
		}
		if( in_array($bHtml,array('false','0','off','no')) )
		{
			
			htmlspecialchars_decode() ;
			$sExp = "htmlspecialchars({$sExp})" ;
		}*/
		
		$sDecoratorStartMark = JCAT_UIHtmlNodeCompiler_PrintDecorator::GetMark($aObject) ;
		$sDecoratorEndMark = JCAT_UIHtmlNodeCompiler_PrintDecorator::GetMark($aObject,false) ;
		$sWrapStartMark = JCAT_UIHtmlNodeCompiler_Wrapper::GetWrapMark($aObject) ;
		$sWrapEndMark = JCAT_UIHtmlNodeCompiler_Wrapper::GetWrapMark($aObject,false) ;
		$sCompiled = "{$sWrapStartMark}<? JCAT_ASSERT::ASSERT_INSTANCE(\$TheModel,'JCAT_IModel',JCAT_Language::Sentence('未设置模型；正在访问模型的模板文件：“%s”。','{$sTemplateFile}')) ;
		print {$sDecoratorStartMark}{$sExp}{$sDecoratorEndMark} ; ?>{$sWrapEndMark}
" ;

		$aObject->SetCompiled($sCompiled) ;
		
		// 后续处理
		$aWrapperCompiler = JCAT_Singleton::GetGlobalInstance('JCAT_UIHtmlNodeCompiler_Wrapper') ;
		$aObject->PutInCompiler($aWrapperCompiler) ;
		$aDecoratorCompiler = JCAT_Singleton::GetGlobalInstance('JCAT_UIHtmlNodeCompiler_PrintDecorator') ;
		$aObject->PutInCompiler($aDecoratorCompiler) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{
		// Node Name 上级名称空间 的 编译器
		include_once( dirname(__FILE__).'/class.JCAT_ViewHtmlNodeCompiler_Model.php' ) ;
		$aParent = JCAT_Singleton::GetGlobalInstance('JCAT_ViewHtmlNodeCompiler_Model') ;
		$aParentManager = $aParent->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aParentManager,'JCAT_IUIObjectProcessorManager') ;
		
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aParentManager->RegisterProcessor( 'data', __CLASS__ ) ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>