<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlNodeCompiler_UICtrl_Item.php 1743 2009-04-27 13:07:25Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlNodeCompiler_UICtrl_Item extends JCAT_UIHtmlNodeCompilerBase
{

	public function JCAT_ViewHtmlNodeCompiler_UICtrl_Item()
	{
		$this->JCAT_UIHtmlNodeCompilerBase() ;
	
		$this->arrNotNullAttributes[] = 'uictrl' ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{ return false ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIHtmlNode') ;
		
		// 节点属性
		$aAttribute = $aObject->GetAttribute() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		
		// 节点内容
		$aBody = $aObject->GetBody() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aBody,'JCAT_UIHtmlObject') ;
		
		// Item
		$sItem = trim($aBody->GetCompiled()) ;
		
		// UICtrl
		$sUICtrlName = $aAttribute->GetAttribute('uictrl') ;

		
		$sCompiled = "<?php
JCAT_ASSERT::ASSERT_(isset(\$TheView),'No \$TheView!!') ;
JCAT_ASSERT::ASSERT_INSTANCE(\$TheView,'JCAT_IView') ;

\$aUICtrl = \$TheView->GetUICtrl('{$sUICtrlName}') ;
JCAT_ASSERT::ASSERT_INSTANCE(\$aUICtrl,'JCAT_UICtrlHtmlMultiItem',JCAT_Language::SentenceEx('名为：“%s”的UICtrl 不存在或不是 JCAT_UICtrlHtmlMultiItem 对象。','JCAT',null,'{$sUICtrlName}')) ;

\$aItem = \$aUICtrl->GetItem({$sItem}) ;
JCAT_ASSERT::ASSERT_INSTANCE(\$aItem,'JCAT_UICtrlItem',JCAT_Language::SentenceEx('控件“%s”没有序号为“%s”的 Item','JCAT',null,'{$sUICtrlName}',{$sItem}) ) ;

\$aItem->Display(\$aUICtrl) ;
?>" ;		
		$aObject->SetCompiled($sCompiled) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{
		// Node Name 上级名称空间 的 编译器
		include_once( dirname(__FILE__).'/class.JCAT_ViewHtmlNodeCompiler_UICtrl.php' ) ;
		$aParent = JCAT_Singleton::GetGlobalInstance('JCAT_ViewHtmlNodeCompiler_UICtrl') ;
		$aParentManager = $aParent->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aParentManager,'JCAT_IUIObjectProcessorManager') ;

		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aParentManager->RegisterProcessor( 'item', __CLASS__ ) ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>