<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlNodeCompiler_View.php 1758 2009-04-28 10:11:18Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlNodeCompiler_View extends JCAT_UIHtmlNodeCompilerBase
{

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{ return true ; }


	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aAttribute		JCAT_UIHtmlNodeAttribute
	 * @return	void
	 */
	public function SetExpressionAttributes(JCAT_UIHtmlNodeAttribute $aAttribute)
	{
		$aAttribute->AddExpressionAttribute('instance');
		$aAttribute->AddExpressionAttribute('parent');
		$aAttribute->AddExpressionAttribute('name.parent');
	}
	


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		$aAttribute = $aObject->GetAttribute() ;
		
		$sInstanceExp = $aAttribute->GetAttribute('instance') ;
		
		// get view instance by expression
		if( $sInstanceExp )
		{
			$sInstanceExpEsc = addslashes($sInstanceExp) ;
			$sCompiled = "<?
\$aView = {$sInstanceExp} ;
JCAT_ASSERT::ASSERT_INSTANCE(\$aView,'JCAT_IViewHtml',JCAT_Language::SentenceEx('表达式：“%s”返回的不是一个有效的 JCAT_IViewHtml 视图。','JCAT',null,'{$sInstanceExpEsc}')) ;
\$aView->ShowView() ;
?>" ;
		}
		
		// get view instance by name
		else 
		{
			$sNameRecursion = $aAttribute->GetAttribute('name.recursion') ;
			if($sNameRecursion===null)
			{
				$sNameRecursion = 'false' ;
			}

			
			$sViewName = $this->GetViewName($aObject,$aAttribute) ;
			if(!$sViewName)
			{
				throw new JCAT_UIHtmlObjectException($aObject, 
					JCAT_Language::SentenceEx('缺少必要属性：instance 或 name', 'JCAT', null)
				) ;
			}
			
			$sViewNameParent = $this->GetNameParent($aAttribute) ;

			$sCompiled = "<?
\$aView = {$sViewNameParent}->GetView({$sViewName},{$sNameRecursion}) ;
JCAT_ASSERT::ASSERT_INSTANCE(\$aView,'JCAT_IViewHtml',JCAT_Language::SentenceEx('视图：“%s”未定义。','JCAT',null,{$sViewName})) ;
\$aView->ShowView() ;
?>" ;
		}

		$aObject->SetCompiled($sCompiled) ;
		return $sCompiled ;
		
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	string
	 */
	private function GetNameParent($aAttribute)
	{
		$sViewNameParent = $aAttribute->GetAttribute('name.parent') ;
		if(!$sViewNameParent)
		{
			$sViewNameParent = '$TheView' ;
		}
		
		else 
		{
			$sViewNameParent = trim($sViewNameParent) ;
		
			if( !preg_match('/^\$/',$sViewNameParent) )
			{
				$sViewNameParent = '$'.$sViewNameParent ;
			}
		}
		
		return $sViewNameParent ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aAttribute
	 * @return	string
	 */
	public function GetViewName($aObject,JCAT_UIHtmlNodeAttribute $aAttribute)
	{
		$sViewName = $aAttribute->GetAttribute('name') ;
		
		// get view instance by node body
		if( !$sViewName )
		{
			$aBody=$aObject->GetBody() ;
			if($aBody)
			{
				// 视图名称
				JCAT_ASSERT::ASSERT_INSTANCE($aBody,'JCAT_UIHtmlObject') ;
				$sViewName = $aBody->GetCompiled() ;
			}
			
			else 
			{
				return null ;
			}
		}

		$sViewName = trim($sViewName) ;
		if( !$aAttribute->IsExpressionAttribute('name') )
		{
			return "'{$sViewName}'" ;
		}
		
		else 
		{
			return $sViewName ;
		}
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{		
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aGlobalManager->RegisterProcessor( 'view', __CLASS__ ) ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>