<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlHtmlMenuItem.php 2021 2009-09-24 11:52:13Z aleechou $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlHtmlMenuItem extends JCAT_UICtrlHtmlBase implements JCAT_IUICtrlHtmlMenuItem
{
	const LINK_DONOTHING = 'javascript:void(0)' ;
	
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_UICtrlHtmlMenuItem(JCAT_IUICtrlHtmlMenu $aMenu,$sItemText,$sLink=self::LINK_DONOTHING,$bActive=false,JCAT_UIHtml $aUI=null)
	{
		$this->JCAT_UICtrlHtmlBase($sItemText,"JCAT_MENU_ITEM_{$sItemText}",$aUI) ;
		$this->sMainUITemplate = dirname(__FILE__).'/../../Resource/template.JCAT_UICtrlHtmlMenu.html' ;
		
		// 
		$this->SetItemText($sItemText) ;
		$this->SetLink($sLink);
		$this->SetActive($bActive) ;
		$this->SetParentMenu($aMenu) ;	
	}
	
	/**
	 * 设置对象属性 self::$sLink
	 *
	 * @access	public
	 * @param	$sLink		string	PropertyDescription
	 * @return	void
	 */
	public function SetLink($sLink)
	{
		$this->sLink = $sLink ;
	}
	
	/**
	 * 取得对象属性 self::$sLink
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetLink()
	{
		return $this->sLink ;
	}
	
	/**
	 * 设置对象属性 self::$sOnClick
	 *
	 * @access	public
	 * @param	$sOnClick		string	PropertyDescription
	 * @return	void
	 */
	public function SetOnClick($sOnClick)
	{
		$this->sOnClick = $sOnClick ;
	}
	
	/**
	 * 取得对象属性 self::$sOnClick
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetOnClick()
	{
		return $this->sOnClick ;
	}

	/**
	 * 设置对象属性 self::$aMenu
	 *
	 * @access	public
	 * @param	$aMenu		JCAT_IUICtrlHtmlMenu	PropertyDescription
	 * @return	void
	 */
	public function SetParentMenu(JCAT_IUICtrlHtmlMenu $aMenu)
	{
		$this->aParentMenu = $aMenu ;
	}
	
	/**
	 * 取得对象属性 self::$aMenu
	 *
	 * @access	public
	 * @return	JCAT_IUICtrlHtmlMenu
	 */
	public function GetParentMenu()
	{
		return $this->aParentMenu ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemText		string
	 * @return	void ;
	 */
	public function SetItemText($sItemText)
	{
		$this->sItemText = strval($sItemText) ;
	}
	
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetItemText()
	{
		return $this->sItemText ;
	}
	
	/**
	 * 设置菜单项是否选中状态
	 *
	 * @access	public
	 * @param	$bActive=true		bool
	 * @return	void
	 */
	public function SetActive($bActive=true)
	{
		$this->bActive = $bActive? true: false ;
	}
	
	/**
	 * 返回菜单项是否选中状态
	 *
	 * @access	public
	 * @return	bool
	 */
	public function GetActive()
	{
		return $this->bActive ;
	}
	
	/**
	 * 设置对象属性 self::$sTarget
	 *
	 * @access	public
	 * @param	$sTarget		string	PropertyDescription
	 * @return	void
	 */
	public function SetTarget($sTarget)
	{
		$this->sTarget = $sTarget ;
	}
	
	/**
	 * 取得对象属性 self::$sTarget
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTarget()
	{
		return $this->sTarget ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUI	JCAT_UIHtml	What's this Parameter ?
	 * @return	void
	 */
	public function Display()
	{
		$aUI = $this->GetUI() ;
		$aOldVars = $aUI->CreateVarSetMemento() ;
		$aUI->SetVar('TheMenuItem',$this) ;
		$aUI->SetVar('TheCSSTheme',$this->GetCSSTheme()) ;

		$aUI->Display(dirname(__FILE__).'/../../Resource/template.JCAT_UICtrlHtmlMenuItem.html') ;

		$aUI->SetVarSetMemento($aOldVars) ;
	}
	
	/**
	 * 设置 子菜单
	 *
	 * @access	public
	 * @param	$aChildMenu		JCAT_UICtrlHtmlMenu
	 * @return	void
	 */
	public function SetChildMenu(JCAT_IUICtrlHtmlMenu $aChildMenu,$bInheritTheme=true)
	{
		$this->aChildMenu = $aChildMenu ;
		
		// 菜单深度
		$aParent = $this->GetParentMenu() ;
		if($aParent)
		{
			$aChildMenu->SetDepth( $aParent->GetDepth()+1 ) ;
		}
		
		if($bInheritTheme)
		{
			$aChildMenu->SetCSSTheme($this->GetCSSTheme()) ;
		}
		
		$aChildMenu->SetParentItem($this) ;
	}
	
	/**
	 * 返回 子菜单
	 *
	 * @access	public
	 * @return	JCAT_UICtrlHtmlMenu
	 */
	public function GetChildMenu()
	{
		return $this->aChildMenu ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassNameStream()
	{
		$arrStyleItems = array(
				JCAT_UICtrlHtmlMenu::CSSITEM_MENUITEM ,
				$this->GetActive()?
						JCAT_UICtrlHtmlMenu::CSSITEM_ACTIVE:
						JCAT_UICtrlHtmlMenu::CSSITEM_UNACTIVE
		) ;
		
		$aTheme = $this->GetCSSTheme() ;
		$sClassForTheme = $aTheme->GetClassName($arrStyleItems) ;
		if(!$sClassForTheme)
		{
			$sClassForTheme.= ' ' ;
		}
		
		return $sClassForTheme.parent::GetClassNameStream() ;
	}
	

	/**
	 * 设置对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @param	$aCSSTheme		JCAT_CSSTheme	PropertyDescription
	 * @return	void
	 */
	public function SetCSSTheme(JCAT_CSSTheme $aCSSTheme)
	{
		$this->aCSSTheme = $aCSSTheme ;
	}
	
	/**
	 * 取得对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @return	JCAT_CSSTheme
	 */
	public function GetCSSTheme()
	{
		return $this->aCSSTheme? $this->aCSSTheme: $this->aParentMenu->GetCSSTheme() ;
	}
	
	
	
	// 属性 /////////////////////////////////////////////
	
	private $sItemText ;
	
	private $bActive = false ;

	private $aChildMenu ;
	
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		JCAT_IUICtrlHtmlMenu
	 */
	private $aParentMenu ;
	
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sOnClick ;
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sLink ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_CSSTheme
	 */
	private $aCSSTheme ;
	
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sTarget ;
	
}

?>