<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IUICtrlHtmlMenu.php 1894 2009-06-10 08:18:22Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IUICtrlHtmlMenu extends JCAT_IUICtrlHtml
{

	/**
	 * 添加菜单项目
	 *
	 * @access	public
	 * @param	
	 * @return	void
	 */
	public function AddItem(JCAT_IUICtrlHtmlMenuItem $aMenuItem) ;

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sText
	 * @return	JCAT_IUICtrlHtmlMenuItem
	 */
	public function GetItem($sText,$bRecursion=false) ;
	
	/**
	 * 返回 Item 的数量
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetItemCount() ;
	
	/**
	 * 设置菜单的深度, start from 0
	 *
	 * @access	public
	 * @param	$nDepth
	 * @return	void
	 */
	public function SetDepth($nDepth) ;
	
	/**
	 * 取得菜单的深度, start from 0
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDepth() ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateItemIterator() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sXML					string
	 * @param	$bClearBefore=false		string
	 * @return	void
	 */
	public function BuildMenuFromXML($sXML,$bClearBefore=false,$sLanguageName=null) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function LoadMenuItemsFromXML(SimpleXMLElement $aXML,$sLanguageName=null) ;
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrPath		array
	 * @return	void
	 */
	public function GetChildMenu($arrPath) ;
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrPath		array
	 * @param	$bActive=true	bool
	 * @return	void
	 */
	public function SetActiveByPath($arrPath,$bActive=true) ;
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nIndent			int
	 * @param	$bRecursion=true	bool
	 * @return	void
	 */
	public function SetIndent($nIndent,$bRecursion=true) ;
	
	
	/**
	 * 参数 $arrSort 是一个多维数组，表示菜单的顺序
	 * $arrSort 的结构为： 
	 * array(
	 * 	'Item Text' => null ,
	 * 	'Item Text' => array(
	 * 		'Child Item Text' => null
	 * 	) 
	 * )
	 * 
	 *
	 * @access	public
	 * @param	$arrSort
	 * @return	void
	 */
	public function SortMenuItems(array $arrSort) ;
	
	
	/**
	 * SortMenuItems() 的逆向操作
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetMenuOrder() ;
	
	
	/**
	 * 设置对象属性 self::$aParentItem
	 *
	 * @access	public
	 * @param	$aParentItem		JCAT_IUICtrlHtmlMenuItem	PropertyDescription
	 * @return	void
	 */
	public function SetParentItem(JCAT_IUICtrlHtmlMenuItem $aParentItem) ;
	
	/**
	 * 取得对象属性 self::$aParentItem
	 *
	 * @access	public
	 * @return	JCAT_IUICtrlHtmlMenuItem
	 */
	public function GetParentItem() ;
	
}

?>