<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlHtmlPagination.php 1878 2009-05-28 08:34:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlHtmlPagination extends JCAT_UICtrlHtmlBase
		implements JCAT_IPagination
{

	public function JCAT_UICtrlHtmlPagination( $sName, $sSlidingWindowClass='JCAT_StaticSlidingWindow', JCAT_UIHtml $aUI=null )
	{		
		JCAT_ASSERT::ASSERT_ISCLASS($sSlidingWindowClass,array('JCAT_ISlidingWindow'),
				JCAT_Language::SentenceEx('参数 $sSlidingWindowClass 必须为实现JCAT_ISlidingWindow 接口的类名传入值为：“%s”','JCAT',null,$sSlidingWindowClass))  ;
		
		$this->JCAT_UICtrlHtmlBase( $sName, $sName, $aUI ) ;
		
		// 创建滑动窗口
		$this->aSlidingWindow = new $sSlidingWindowClass() ;
		
		// 主模版
		$this->sMainUITemplate = dirname(__FILE__).'/../Resource/template.JCAT_UICtrlHtmlPagination.html' ;

		// 样式
		$aUI = $this->GetUI() ;
		$aUI->AddHTMLRC(new JCAT_CSS('JCAT_UICtrlHtmlPagination.css')) ;
		
		// 初始化页码
		$sPageKey = $this->GetHTTPRequestVariableName() ;
		$this->SetPageNumber( empty($_REQUEST[$sPageKey])? 1: $_REQUEST[$sPageKey] ) ;
	}

	/**
	 * 设置 总页数
	 *
	 * @access	public
	 * @param	$nPageCount	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetPageCount( $nPageCount )
	{
		JCAT_ASSERT::ASSERT_INT($nPageCount)  ;
		JCAT_ASSERT::ASSERT_($nPageCount>0
			, JCAT_Language::SentenceEx('参数 $nPageCount 必须为正整数;传入值为：“%s”','JCAT',null,$nPageCount))  ;
		
		list(,$old_value) = $this->aSlidingWindow->GetSlideRange() ;
		$this->aSlidingWindow->SetSlideRange(1,$nPageCount) ;
		$this->aSlidingWindow->SetPosition( $this->GetPageNumber() ) ;		
		return $old_value ;
	}
	
	/**
	 * 取得 总页数
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPageCount()
	{
		list(,$nPageCount) = $this->aSlidingWindow->GetSlideRange() ;
		return $nPageCount ;
	}
	
	/**
	 * 返回 当前页数
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPageNumber()
	{
		return $this->nPageNumber ;
	}
	
	/**
	 * 设置页数
	 *
	 * @access	public
	 * @param 	$nPageNumber
	 * @return	void
	 */
	public function SetPageNumber($nPageNumber)
	{
		$this->nPageNumber = intval($nPageNumber) ;
	}
	
	/**
	 * 取得 HTTP Request 变亮名
	 *
	 * @access	public
	 * @param	
	 * @return	void
	 */
	public function GetHTTPRequestVariableName()
	{
		return 'PageNumberFor_'.$this->GetName() ;
	}

	/**
	 * 用于显示的第一页
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetFirstPage()
	{
		list($nStartPage,) = $this->aSlidingWindow->GetWindowBundary() ;
		return $nStartPage ;
	}

	/**
	 * 用于显示的最后页
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetLastPage()
	{
		list(,$nEndPage) = $this->aSlidingWindow->GetWindowBundary() ;
		return $nEndPage ;
	}
	
	/**
	 * 将当前页面的 Get/Post 参数带入页码的URL中
	 *
	 * @access	public
	 * @param	$nPageNum		int
	 * @return	string
	 */
	public function GetUrlForPageNum($nPageNum)
	{
		$arrParameter = array( $this->GetHTTPRequestVariableName() => $nPageNum ) ;
		return '?'.JCAT_Global::Array2UrlQeruy( array_merge($_GET,$arrParameter) ) ;
	}

	/**
	 * 取得滑动到前一个页码窗口的 url
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUrlForSlidePrevious()
	{
		$nPageNum = $this->aSlidingWindow->SlideBackward(true) ;
		return $this->GetUrlForPageNum($nPageNum) ;
	}
	
	/**
	 * 取得滑动到后一个页码窗口的 url
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUrlForSlideNext()
	{
		$nPageNum = $this->aSlidingWindow->SlideForward(true) ;
		return $this->GetUrlForPageNum($nPageNum) ;
	}

	/**
	 * 是否存在前一个页码滑动窗口
	 *
	 * @access	public
	 * @return	bool
	 */
	public function HasPreviousSlidingWindow()
	{
		return $this->GetFirstPage()>1 ;
	}
	
	/**
	 * 是否存在后一个页码滑动窗口
	 *
	 * @access	public
	 * @return	bool
	 */
	public function HasNextSlidingWindow()
	{
		return $this->GetLastPage() < $this->GetPageCount() ;
	}
	
	

	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetStartPos()
	{
		$aPaginal = $this->GetPaginal() ;
		return $aPaginal? 
					($aPaginal->GetCountPerPage() * ($this->GetPageNumber()-1)): -1 ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetEndPos()
	{
		$nStartPos = $this->GetStartPos() ;
		return $nStartPos<0 ? -1: ($nStartPos+$this->GetCountPerPage()) ;
	}
	
	/**
	 * 设置可分页对象
	 *
	 * @access	public
	 * @param	$aPaginal	JCAT_IPaginal
	 * @return	void
	 */
	public function SetPaginal(JCAT_IPaginal $aPaginal)
	{
		$this->aPaginal = $aPaginal ;
	}
	
	/**
	 * 返回可分页对象
	 *
	 * @access	public
	 * @return	JCAT_IPaginal
	 */
	public function GetPaginal()
	{
		return $this->aPaginal ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	
	/**
	 * 页码的滑动窗口
	 * 
	 * @access	private
	 * @var		JCAT_ISlidingWindow
	 */
	private $aSlidingWindow ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nPageNumber = 1 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IPaginal
	 */
	private $aPaginal ;
}
?>