<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlHtmlFile.php 1877 2009-05-28 07:00:25Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlHtmlFile extends JCAT_UICtrlFormHtmlBase
{

	public function JCAT_UICtrlHtmlFile( $sName, $strStoreDir, $sUIName='', JCAT_UIHtml $aUI=null )
	{
		$this->JCAT_UICtrlHtmlBase( $sName, $sUIName, $aUI ) ;
		$this->sMainUITemplate = dirname(__FILE__).'/../Resource/template.JCAT_UICtrlHtmlFile.html' ;

		$aUploader = new JCAT_UploadFile($strStoreDir) ;
		$this->SetUploader($aUploader) ;
	}
	
	/**
	 * 设置属性： Uploader对象
	 *
	 * @access	public
	 * @param	$aUploader		JCAT_UploadFile		Uploader对象
	 * @return	old_value
	 */
	public function SetUploader(JCAT_UploadFile $aUploader)
	{
		$old_value = $this->aUploader ;
		$this->aUploader = $aUploader ;
		return $old_value ;
	}
	
	/**
	 * 取得属性： Uploader对象
	 *
	 * @access	public
	 * @return	JCAT_UploadFile
	 */
	public function GetUploader()
	{
		return $this->aUploader ;
	}
	

	/**
	 * 在此简单的从一个 HTML Form 中取得用户输入
	 * 更高级的 方式，请在派生类中 重載此函数
	 * 
	 * @access	public
	 * @param	$aUserRequest		JCAT_Request	用户请求
	 * @return	void
	 */
	public function SetDataFromSubmited(JCAT_Request $aUserRequest)
	{
		// Input Name
		$sInputName = $this->GetName() ;
		
		// 旧文件
		$sOldFileStorePath = $this->GetFileStorePath() ;
	
		// 用户请求
		$bUploading = $this->aUploader->IsUploading($sInputName,$aUserRequest) ;
		$bDeleteRequest = $this->IsDeleting() ;
		
		// 用户 删除请求
		if( $bDeleteRequest or ($bUploading and $sOldFileStorePath) )
		{
			$sOldFilename = $this->GetFilename() ;
			
			if( @unlink($sOldFileStorePath) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('文件：%s 已经删除','JCAT',null,$sOldFilename),MSGMVC_OK) ;
				parent::SetDataByExchange('') ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('删除文件：%s 失败','JCAT',null,$sOldFilename),MSGMVC_BAD) ;
			}
		}
		
		if( !$bUploading )
		{
			return ;
		}
		
		// 上传
		if( !$this->aUploader->Upload($sInputName,$aUserRequest) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('上传失败(%s)：%s','JCAT',null,$sInputName,$this->aUploader->GetErrorMsg($sInputName)),MSGMVC_BAD) ;
			parent::SetDataByExchange(null) ;
		}

		else
		{						
			new JCAT_Message(JCAT_Language::SentenceEx('上传文件：%s(%s)','JCAT',null
						, $this->aUploader->GetOriginalName($sInputName,$aUserRequest)
						, JCAT_UploadFile::GetReadableFileSize($this->aUploader->GetLength($sInputName,$aUserRequest)))
				, MSGMVC_OK) ;

			// 设置 新文件
			parent::SetDataByExchange($this->aUploader->GetStoreSubPath()) ;
		}
	}
	
	/**
	 * 取得原始文件名
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetOriginalFilename()
	{
		return $this->GetFilename(true) ;
	}
		
	/**
	 * 取得文件名
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetFilename( $bOriginalName=false )
	{
		$sStoreSubPath = parent::GetExchangeData() ;
		if( $sStoreSubPath )
		{
			// 取得文件名
			$sFilename = basename($sStoreSubPath) ;
			return $bOriginalName? JCAT_UploadFile::GetOriginalNameFromStoreName($sFilename): $sFilename ;
		}
		
		else
		{
			return '' ;
		}
		
	}

	
	/**
	 * 取得文件存储路径
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetFileStorePath()
	{
		$sFilename = $this->GetFilename() ;
		if(!$sFilename)
		{
			return '' ;
		}
		
		else
		{
			return $this->aUploader->GetStoreDir() . $this->aUploader->GetStoreSubDir() . $sFilename;
		}
	}

	/**
	 * 取得文件存储路径
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetFileAccessUrl()
	{
		$sFileStorePath = $this->GetFileStorePath() ;
		if( !is_file($sFileStorePath) )
		{
			return null ;
		}
		
		return $sFileStorePath? JCAT_DownloadFile::GetHTTPAccessPath($sFileStorePath): null ; 
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function FileExists()
	{
		$sFileStorePath = $this->GetFileStorePath() ;
		return is_file($sFileStorePath) ;
	}
	
	/**
	 * 取的文件尺寸
	 *
	 * @access	public
	 * @param	$bReadale
	 * @return	string
	 */
	public function GetFileSize($bReadale=false)
	{
		$sFileStorePath = $this->GetFileStorePath() ;
		if( is_file($sFileStorePath) )
		{
			$nFileSize = filesize($sFileStorePath) ;
		}
		
		else
		{
			$nFileSize = 0 ;
		}
		
		if( $bReadale )
		{
			return JCAT_UploadFile::GetReadableFileSize($nFileSize) ;
		}
		
		else
		{
			return $nFileSize ;
		}
	}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		return $this->GetFileSize(false) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDeleteInputName()
	{
		return $this->GetName().'DeleteInput' ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsDeleting()
	{
		return !empty($_REQUEST[ $this->GetDeleteInputName() ]) ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 文件名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sFilename = '' ;
	
	/**
	 * 对象属性 Uploader 对象
	 * 
	 * @access	private
	 * @var		JCAT_UploadFile
	 */
	private $aUploader ;
	
//我检查了一下 A 上面的 DBFactory.inc.php 和 db.inc.php

}
?>