<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlItem.php 1859 2009-05-21 07:20:19Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UICtrlItem extends JCAT_UICtrlHtmlBase
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sValue			string	What's this Parameter ?
	 * @param	$sText=null		string	What's this Parameter ?
	 * @param	$bActive=false	string	What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_UICtrlItem( $sText, $sValue=null,  $bActive=false, JCAT_UIHtml $aUI=null ) 
	{
		if($sValue===null)
		{
			$sValue = $sText ;
		}
		
		$this->JCAT_UICtrlHtmlBase( 'UICtrlItem_'.++self::$nUICtrlItemID, '', $aUI ) ;
		
		$this->sText = strval($sText) ;
		$this->sValue = strval($sValue) ;
		$this->bActive = $bActive? true: false ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetValue() 
	{ return $this->sValue ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetText(  ) 
	{ return $this->sText ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bActive=true	bool	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetActive( $bActive=true ) 
	{
		$old_value = $this->bActive ;
		$this->bActive = $bActive? true: false ;
		return $old_value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function GetActive(  ) 
	{ return $this->bActive ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUI		JCAT_UIHtml					What's this Parameter ?
	 * @param	$aUICtrl	JCAT_UICtrlHtmlMultiItem	What's this Parameter ?
	 * @return	void
	 */
	public function Display( JCAT_UICtrlHtmlMultiItem $aUICtrl=null )
	{
		JCAT_ASSERT::ASSERT_FILE($this->sMainUITemplate,JCAT_Language::SentenceEx('UICtrlHtml：“%s”尚未设置 有效的模版文件。%s','JCAT',null,get_class($this),$this->sMainUITemplate)) ;
		JCAT_ASSERT::ASSERT_NOTNULL($aUICtrl,JCAT_Language::SentenceEx('参数 $aUICtrl 不能为 Null','JCAT',null)) ;
		
		$aUI = $this->GetUI() ;
		$aOldVars = $aUI->CreateVarSetMemento() ;
		$aUI->SetVar('TheUICtrl',$aUICtrl) ;
		$aUI->SetVar('theItem',$this) ;
		
		$aUI->Display($this->sMainUITemplate) ;
		
		$aUI->SetVarSetMemento($aOldVars) ;
	}
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	private $sText ;
	
	private $sValue ;
	
	private $bActive = false ;
	
	
	static $nUICtrlItemID = 0 ;

}
?>