<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlItemBox.php 1943 2009-07-23 06:44:28Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlItemBox extends JCAT_UICtrlItemCheck
{



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sValue			string	What's this Parameter ?
	 * @param	$sText=null		string	What's this Parameter ?
	 * @param	$bActive=false	string	What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_UICtrlItemBox( $sText, $sValue=null, $bActive=false, JCAT_UIHtml $aUI=null ) 
	{
		$this->JCAT_UICtrlItem($sText,$sValue,$bActive,$aUI) ;
		$this->sMainUITemplate = dirname(__FILE__).'/../Resource/template.JCAT_UICtrlItemCheckbox.html' ;
    }


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUI		JCAT_UIHtml					What's this Parameter ?
	 * @param	$aUICtrl	JCAT_UICtrlHtmlMultiItem	What's this Parameter ?
	 * @param	$nItemIdx	int                     	What's this Parameter ?
	 * @return	void
	 */
	public function Display( JCAT_UICtrlHtmlMultiItem $aUICtrl=null, $nItemIdx=null )
	{
        JCAT_ASSERT::ASSERT_INT($nItemIdx) ;
		JCAT_ASSERT::ASSERT_NOTNULL($aUICtrl,JCAT_Language::SentenceEx('参数 $aUICtrl 不能为空。','JCAT',null)) ;
		
		$aUI = $this->GetUI() ;
		$aOldVars = $aUI->CreateVarSetMemento() ;
		$aUI->SetVar('nItemIdx',$nItemIdx) ;
		
		JCAT_UICtrlItem::Display($aUICtrl) ;
		
		$aUI->SetVarSetMemento($aOldVars) ;
	}
}
?>