<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlFormHtmlBase.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UICtrlFormHtmlBase extends JCAT_UICtrlHtmlBase implements JCAT_IUICtrlFormHtml
{
	/**
	 * 在此简单的从一个 HTML Form 中取得用户输入
	 * 更高级的 方式，请在派生类中 重載此函数
	 * 
	 * @access	public
	 * @param	$aUserRequest		JCAT_Request	用户请求
	 * @return	void
	 */
	public function SetDataFromSubmited(JCAT_Request $aUserRequest)
	{
		$this->Value = $aUserRequest->GetParam($this->GetName()) ;
	}
	
	


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Value	mixed	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetDataByExchange( $Value )
	{
		$old_value = $this->Value ;
		$this->Value = $Value ;
		return $old_value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function GetExchangeData()
	{
		return $this->Value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aVerifier	JCAT_IUICtrlVerifier	What's this Parameter ?
	 * @return	void
	 */
	public function AddVerifier( JCAT_IUICtrlVerifier $aVerifier )
	{
		$this->arrVerifiers[] = $aVerifier ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function ClearVerifier()
	{
		$this->arrVerifiers = array() ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function VerifyData()
	{
		foreach($this->arrVerifiers as $aVerifier)
		{
			if( !$aVerifier->VerifyData($this) )
			{
				return false ;
			}
		}
		
		return true ;
	}

	/**
	 * 取得 HTML 表单名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetFormName()
	{
		return $this->GetName().'Form' ;
	}
	/**
	 * 创建/载入 数据校验器
	 *
	 * @access	public
	 * @return	void
	 */
	public function LoadJSDataVeirifier()
	{
		$sDataVerifierName = 'aDataVerifer' ;
		$sUICtrlName = $this->GetJSVariableName() ;
		
		print "<script>\r\n" ;
		foreach($this->arrVerifiers as $aVerifier)
		{
			if( !JCAT_Global::HasImplementedTo($aVerifier,'JCAT_IUICtrlHtmlVerifier') )
			{
				continue ;
			}

			print $aVerifier->CreateJSVerifier($sDataVerifierName) ;
			print "\r\n{$sUICtrlName}.AddDataVerifier({$sDataVerifierName}) ;\r\n" ;
			print "\r\n" ;
		}
		print "</script>\r\n" ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	protected $Value ;
	
	private $arrVerifiers = array() ;

}


?>