<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlHtmlBase.php 1861 2009-05-22 05:44:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UICtrlHtmlBase extends JCAT_UICtrlBase
		implements JCAT_IUICtrlHtml, JCAT_IJSObject
{

	public function JCAT_UICtrlHtmlBase( $sName, $sUIName='', JCAT_UIHtml $aUI=null)
	{
		$this->SetName($sName,$sUIName) ;
		$this->SetHtmlId($sName.'Id') ;
		
		if(!$aUI)
		{
			$aUI = JCAT_ViewHtml::CreateShareUI() ;
		}
		$this->SetUI($aUI) ;
	}

	/**
	 * 取得 JS UI控件对象的变量名
	 *
	 * @access	public
	 * @param	
	 * @return	void
	 */
	public function GetJSVariableName()
	{
		return 'theUICtrl' . $this->GetName() ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sHtmlId	string	What's this Parameter ?
	 * @return	string
	 */
	public function SetHtmlId( $sHtmlId )
	{
		JCAT_ASSERT::ASSERT_STRING($sHtmlId) ;
		return $this->sHtmlId = $sHtmlId ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetHtmlId()
	{
		return $this->sHtmlId ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetStyle( $sName, $sValue )
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		
		$old_value = isset($this->arrStyles[$sName])? $this->arrStyles[$sName]: null ;
		$this->arrStyles[$sName] = $sValue ;
		return $old_value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	string, null
	 */
	public function GetStyle( $sName ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		return isset($this->arrStyles[$sName])? $this->arrStyles[$sName]: null ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetStyleStream()
	{
		$arrStream = array() ;
		foreach($this->arrStyles as $sStyleName=>$sStyleCode)
		{
			$arrStream[] = "{$sStyleName}:{$sStyleCode}" ;
		}
		
		return implode(';',$arrStream) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	string
	 */
	public function RemoveStyle(  $sName )
	{
		$old_value = isset($this->arrStyles[$sName])? $this->arrStyles[$sName]: null ;
		unset($this->arrStyles[$sName]) ;
		return $old_value ;		
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetAttribute( $sName, $sValue )
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		
		$sLowName = strtolower($sName) ;
		switch ($sLowName)
		{
			case 'class' :
				$this->arrClassNames = explode(' ',$sValue) ;
				return ;
				
			case 'style' :
				$arrStyles = explode(';',$sValue) ;
				foreach ($arrStyles as $sStyle)
				{
					list($sStyleName,$sStyleValue) = explode(':',$sStyle) ;
					$sStyleName = trim($sStyleName) ;
					$sStyleValue = trim($sStyleValue) ;
					
					$this->SetStyle($sStyleName,$sStyleValue) ;
				}
				return ;
			
			default:
				$old_value = isset($this->arrAttributes[$sName])? $this->arrAttributes[$sName]: null ;
				$this->arrAttributes[$sName] = $sValue ;
				return $old_value ;
		}
	}




	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	string
	 */
	public function GetAttribute( $sName )
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		return isset($this->arrAttributes[$sName])? $this->arrAttributes[$sName]: null ;
	}




	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$nAttrFlag=JCAT_IUICtrlHtml::ATTR_ALL	int	What's this Parameter ?
	 * @return	string
	 */
	public function GetAttributeStream( $nAttrFlag=JCAT_IUICtrlHtml::ATTR_ALL )
	{
		$arrStream = array() ;
		
		// style
		if( $nAttrFlag&JCAT_IUICtrlHtml::ATTR_STYLE )
		{
			$arrStream[] = 'style="'.$this->GetStyleStream().'"' ;
		}
		
		// class
		if( $nAttrFlag&JCAT_IUICtrlHtml::ATTR_CLASSNAME )
		{
			$arrStream[] = 'class="'.$this->GetClassNameStream().'"' ;
		}
		
		// 其他
		if( $nAttrFlag&JCAT_IUICtrlHtml::ATTR_OTHER )
		{
		
			foreach($this->arrAttributes as $sAttrName=>$sAttrCode)
			{
				$arrStream[] = "{$sAttrName}=\"{$sAttrCode}\"" ;
			}
		}
		
		return implode(' ',$arrStream) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	string
	 */
	public function RemoveAttribute(  $sName )
	{
		$old_value = isset($this->arrAttributes[$sName])? $this->arrAttributes[$sName]: null ;
		unset($this->arrAttributes[$sName]) ;
		return $old_value ;		
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUI	JCAT_UIHtml	What's this Parameter ?
	 * @return	void
	 */
	public function Display()
	{
		JCAT_ASSERT::ASSERT_FILE($this->sMainUITemplate,JCAT_Language::SentenceEx('UICtrlHtml：“%s”尚未设置 有效的模版文件。%s','JCAT',null,get_class($this),$this->sMainUITemplate)) ;
		
		$aUI = $this->GetUI() ;
		$aOldVars = $aUI->CreateVarSetMemento() ;
		$aUI->SetVar('TheUICtrl',$this) ;
		$aUI->SetVar('TheCSSTheme',$this->GetCSSTheme()) ;
		
		$aUI->Display($this->sMainUITemplate) ;
		
		$aUI->SetVarSetMemento($aOldVars) ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sTemplate	string		What's this Parameter ?
	 * @return	void
	 */
	public function SetUITemplate( $sTemplate )
	{
		JCAT_ASSERT::ASSERT_STRING($sTemplate) ;
		$this->sMainUITemplate = $sTemplate ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddClassName($sClassName)
	{
		$this->arrClassNames[$sClassName] = $sClassName ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function RemoveClassName($sClassName)
	{
		unset($this->arrClassNames[$sClassName]) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function CreateClassNameIter()
	{
		return new JCAT_ArrayIterator($this->arrClassNames) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassNameStream()
	{
		return implode(' ',$this->arrClassNames) ;
	}
	
	
	/**
	 * 设置对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @param	$aCSSTheme		JCAT_CSSTheme	PropertyDescription
	 * @return	void
	 */
	public function SetCSSTheme(JCAT_CSSTheme $aCSSTheme)
	{
		$this->aCSSTheme = $aCSSTheme ;
	}
	
	/**
	 * 取得对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @return	JCAT_CSSTheme
	 */
	public function GetCSSTheme()
	{
		return $this->aCSSTheme ;
	}
	
	/**
	 * 设置对象属性 self::$aUI
	 *
	 * @access	public
	 * @param	$aUI		JCAT_UIHtml	PropertyDescription
	 * @return	void
	 */
	public function SetUI(JCAT_UIHtml $aUI)
	{
		$this->aUI = $aUI ;
	}
	
	/**
	 * 取得对象属性 self::$aUI
	 *
	 * @access	public
	 * @return	JCAT_UIHtml
	 */
	public function GetUI()
	{
		return $this->aUI ;
	}
	
	/**
	 * 设置对象属性 self::$bDisable
	 *
	 * @access	public
	 * @param	$bDisable		bool	PropertyDescription
	 * @return	void
	 */
	public function SetDisable($bDisable)
	{
		$this->bDisable = $bDisable? true: false ;
	}
	
	/**
	 * 取得对象属性 self::$bDisable
	 *
	 * @access	public
	 * @return	bool
	 */
	public function GetDisable()
	{
		return $this->bDisable ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////



	private $sHtmlId ;
	
	
	private $arrStyles = array() ;
	
	
	private $arrClassNames = array() ;
	
	
	private $arrAttributes = array() ;
	
	
	protected $sMainUITemplate ;

	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		JCAT_UIHtml
	 */
	private $aUI ;
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		JCAT_CSSTheme
	 */
	private $aCSSTheme ;
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bDisable = false ;
}
?>