<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IUICtrlHtml.php 1741 2009-04-27 11:15:37Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IUICtrlHtml
{
	const ATTR_STYLE = 1 ;
	const ATTR_CLASSNAME = 2 ;
	const ATTR_OTHER = 4 ;
	
	const ATTR_ALL = 7 ;
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sHtmlId	string	What's this Parameter ?
	 * @return	void
	 */
	public function SetHtmlId( $sHtmlId ) ;


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function GetHtmlId(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetStyle( $sName, $sValue )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	string
	 */
	public function GetStyle( $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetStyleStream(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	string
	 */
	public function RemoveStyle(  $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetAttribute( $sName, $sValue )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	string
	 */
	public function GetAttribute( $sName )  ;


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$nAttrFlag=JCAT_IUICtrlHtml::ATTR_ALL	int	What's this Parameter ?
	 * @return	string
	 */
	public function GetAttributeStream( $nAttrFlag=JCAT_IUICtrlHtml::ATTR_ALL )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	string
	 */
	public function RemoveAttribute(  $sName )  ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddClassName($sClassName) ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function RemoveClassName($sClassName) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function CreateClassNameIter() ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassNameStream() ;


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUI	JCAT_UIHtml	What's this Parameter ?
	 * @return	void
	 */
	public function Display()  ;

	/**
	 * 设置对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @param	$aCSSTheme		JCAT_CSSTheme	PropertyDescription
	 * @return	void
	 */
	public function SetCSSTheme(JCAT_CSSTheme $aCSSTheme) ;
	
	/**
	 * 取得对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @return	JCAT_CSSTheme
	 */
	public function GetCSSTheme() ;

	/**
	 * 设置对象属性 self::$aUI
	 *
	 * @access	public
	 * @param	$aUI		JCAT_UIHtml	PropertyDescription
	 * @return	void
	 */
	public function SetUI(JCAT_UIHtml $aUI) ;
	
	/**
	 * 取得对象属性 self::$aUI
	 *
	 * @access	public
	 * @return	JCAT_UIHtml
	 */
	public function GetUI() ;
}
?>