<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_CSSTheme
{
	const DEFAULT_ITEM = '' ;
	
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_CSSTheme($sUsingTheme,$sBaseTheme=null)
	{
		$this->SetUsingTheme($sUsingTheme) ;
		$this->SetBaseTheme($sBaseTheme) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function DefineItem($sItemName='')
	{
		$this->arrDefinedStyleItems[$sItemName] = $sItemName ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName
	 * @return	bool
	 */
	public function IsItemDefined($sItemName)
	{
		return array_key_exists($sItemName,$this->arrDefinedStyleItems) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassName(array $arrItems)
	{
		if(count($arrItems)<1)
		{
			return '' ;
		}
		
		$arrClasses = array() ;
		foreach($arrItems as $sItem)
		{
			$arrClasses[] = $this->GetItemClassName($sItem) ;
		}
		
		return implode(' ',$arrClasses) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName
	 * @return	string
	 */
	public function GetItemClassName($sItemName=self::DEFAULT_ITEM)
	{
		if(!$this->IsItemDefined($sItemName))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'CSS 主题遇到了未定义的样式项目：%s'
				, 'JCAT', null
				, $sItemName
			)) ;
		}
		
		$sClassName = '' ;
		
		// 默认主题
		$sBaseTheme = $this->GetBaseTheme() ;
		if($sBaseTheme)
		{
			$sClassName.= $sBaseTheme ;
			if($sItemName)
			{
				$sClassName.= $this->sNameSpaceOperator ;
			}
			$sClassName.= $sItemName.' ' ;
		}
		
		// 使用主题
		$sUsingTheme = $this->GetUsingTheme() ;
		if($sUsingTheme)
		{
			$sClassName.= $sUsingTheme ;
			if($sItemName)
			{
				$sClassName.= $this->sNameSpaceOperator ;
			}
			$sClassName.= $sItemName.' ' ;
		}
		
		
		return trim($sClassName) ;
	}
	
	/**
	 * 设置对象属性 self::$sUsingTheme
	 *
	 * @access	public
	 * @param	$sUsingTheme		string	PropertyDescription
	 * @return	void
	 */
	public function SetUsingTheme($sUsingTheme)
	{
		$this->sUsingTheme = trim($sUsingTheme) ;
	}
	
	/**
	 * 取得对象属性 self::$sUsingTheme
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUsingTheme()
	{
		return $this->sUsingTheme ;
	}
	
	/**
	 * 设置对象属性 self::$sBaseTheme
	 *
	 * @access	public
	 * @param	$sBaseTheme		string	PropertyDescription
	 * @return	void
	 */
	public function SetBaseTheme($sBaseTheme)
	{
		$this->sBaseTheme = trim($sBaseTheme) ;
	}
	
	/**
	 * 取得对象属性 self::$sBaseTheme
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetBaseTheme()
	{
		return $this->sBaseTheme ;
	}

	
	/**
	 * add a html resource, only call this method inner
	 *
	 * @access	protected
	 * @param	$sFilename		string
	 * @return	void
	 */
	public function DefineFile($sFilename,JCAT_UIHtml $aUI)
	{
		$aUI->AddHtmlRC(new JCAT_CSS($sFilename));
	}
	
	////
	
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sBaseTheme ;
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sUsingTheme ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDefinedStyleItems = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sNameSpaceOperator = '_' ;
}

?>