<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtml.php 2028 2009-10-07 12:10:42Z aleechou $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

$sHere = dirname(__FILE__) ;
include_once $sHere.'/../ViewAndUICtrl/class.JCAT_View.php';
include_once $sHere.'/interface.JCAT_IViewHtml.php';
include_once $sHere.'/interface.JCAT_IJSObject.php';

/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtml extends JCAT_View
		implements JCAT_IViewHtml, JCAT_IJSObject
{

	/**
	 * 
	 * @access	public
	 * @param	$sTemplate		string					模板文件名称
	 * @param	$aParent		JCAT_IViewContainer		父视图 或 控制器
	 * @param	$sName			string					视图名称
	 * @param	$aUI=null		JCAT_UIHtml				UI 对象
	 * @return	void
	 */
	public function JCAT_ViewHtml( $sTemplate, JCAT_IViewContainer $aParent, $sName=null, JCAT_UIHtml $aUI=null )
	{
		JCAT_ASSERT::ASSERT_STRING($sTemplate) ;
		
		// 创建/设置 UI对象
		$this->SetUI($aUI?$aUI:self::CreateShareUI()) ;
		$this->SetTemplate($sTemplate) ;
		
		if(!$sName)
		{
			$sName = $sTemplate ;
		}
		
		// 按照 php的原生处理方式，将不符合变量命名规则的字符转换为"_"
		$sName = preg_replace('/[^\w_]/','_',$sName) ;
		
		// 父类构造函数
		$this->JCAT_View($sName,$aParent) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTemplate		string					模板文件名称
	 * @static
	 * @return	void
	 */
	static public function CreateView($sTemplate)
	{
		return new self('View:'.++self::$nViewGlabalIdx,new JCAT_DoNothing(),$sTemplate) ;
	}

	/**
	 * 取得 JS UI控件对象的变量名
	 *
	 * @access	public
	 * @param	
	 * @return	void
	 */
	public function GetJSVariableName()
	{
		return 'theView' . $this->GetName() ;
	}
	
	/**
	 * 为所有 UIHtml 维护一个共享的 JCAT_UIHtml 全局实例
	 *
	 * @access	public
	 * @return	JCAT_UIHtml
	 */
	static public function CreateShareUI()
	{
		if( !self::$aShareGlobalUI )
		{
			self::$aShareGlobalUI = self::CreateUI() ;
		}
		
		return self::$aShareGlobalUI ;
	}
	
	/**
	 * 创建一个 JCAT_UIHtml 实例
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_UIHtml
	 */
	static public function CreateUI()
	{
		$aUI = new JCAT_UIHtml() ;
			
		// 设置 View Node 编译器
		$aParserManager = $aUI->GetParserManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aParserManager,'JCAT_IUIObjectProcessorManager') ;
		
		$theHtmlNodeParser = $aParserManager->GetProcessor('UI.Html.Node') ;
		JCAT_ASSERT::ASSERT_INSTANCE($theHtmlNodeParser,'JCAT_UIHtmlNodeParser') ;
		
		$theCompilerManager = $theHtmlNodeParser->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($theCompilerManager,'JCAT_IUIObjectProcessorManager') ;
		
		$theCompilerManager->AddAutoloadProcessorDir( dirname(__FILE__).'/NodeCompiler/' ) ;
		
		return $aUI ;
	}
	

	/**
	 * set the ui template filename 
	 * 
	 * @access	public
	 * @param 	$sTemplate		string   the template filename
	 * @return	void
	 */
	public function SetTemplate($sTemplate) 
	{
		$this->sTemplate = $sTemplate ;
	}
	
	/**
	 * get the ui template filename 
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetTemplate() 
	{
		return $this->sTemplate ;
	}



	/**
	 * 显示视图
	 * 
	 * @access	public
	 * @param	$bDisplayAtOnce=true			bool
	 * @return	void
	 */
	public function ShowView($bDisplayAtOnce=true) 
	{
		if(!$this->bEnableView)
		{
			return ;
		}
		
		$aUI = $this->GetUI() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aUI,'JCAT_UIHtml') ;
		
		// 创建 模版变量备忘录
		$aOldVars = $aUI->CreateVarSetMemento() ;
		
		// 设置模版变量
		$aController = $this->GetParentController() ;
		$aModel = $this->GetModel() ;
		$aUI->SetVar('TheView',$this) ;
		$aUI->SetVar('TheController',$aController) ;
		$aUI->SetVar('TheModel',$aModel) ;
		$aUI->SetVar('TheRequest',$aController->GetRequest()) ;
		$aUI->SetVar('TheCSSTheme',$this->GetCSSTheme()) ;
		
		// 显示视图
		if(self::$bShowTemplateFile)
		{
			$sTemplatePath = is_file($this->sTemplate)?
					$this->sTemplate: JCAT_UIHtml::FindTemplate($this->sTemplate) ;
			
			$sRandId = md5(microtime().rand(0,9999)) ;
			echo $sReturn = "<div id='{$sRandId}' class='JCAT_DebugView_Div'>
			<div class='JCAT_DebugView_DivLinks'><a href='javascript:void(0)' title='{$sTemplatePath}'>模板</a> <a href='javascript:void(0)' onclick=\"document.getElementById('{$sRandId}').style.display='none'\">隐藏</a></div>" ;
			
			$sReturn.= $aUI->Display($this->sTemplate,$bDisplayAtOnce?JCAT_UIHtml::OUTPUT_ATONCE: JCAT_UIHtml::RETURN_OUTPUT) ;
			
			echo $sOut = "</div>" ;
			$sReturn.= $sOut ;
		}
		
		else 
		{
			$sReturn = $aUI->Display($this->sTemplate,$bDisplayAtOnce?JCAT_UIHtml::OUTPUT_ATONCE: JCAT_UIHtml::RETURN_OUTPUT) ;			
		}
		
		// 初始化视图
		// $this->InitializeJS() ;
		
		// 恢复模版变量
		$aUI->SetVarSetMemento($aOldVars) ;
		
		return $sReturn ;
	}
	
	
	/**
	 * 启用/禁用 视图
	 * 
	 * @access	public
	 * @param	$bEnableView	bool			what's this
	 * @return	old_value
	 */
	public function EnableView($bEnableView=true)
	{
		$old_value = $this->bEnableView ;
		$this->bEnableView = $bEnableView? true: false ;
		return $old_value ;
	}
	
	
	/**
	 * 初始化JS 视图对象
	 *
	 * @access	public
	 * @return	void
	 */
	public function InitializeViewForHtml()
	{		
		print "<script>\r\n" ;
		
		// 创建JS视图对象
		$this->InitializeJS_ConstructView() ;
		
		// 加入 UICtrl
		$this->InitializeJS_AddUICtrl() ;
		
		// 添加到 父视图
		$this->InitializeJS_AddToParentView() ;
		
		// 加入 子视图
		$this->InitializeJS_AddChildrenView() ;
		
		print "</script>" ;
	}
	
	/**
	 * 设置视图变量
	 *
	 * @access	public
	 * @param	$NameOrVars		array,string		变量名称 或 包含所有变量的数组
	 * @param	$Value				mixed			变量值
	 * @return	old_value
	 */
	public function SetViewVar( $NameOrVars, $Value=null )
	{
		$aUI = $this->GetUI() ;
		return $aUI->SetVar($NameOrVars,$Value) ;
	}
	
	/**
	 * 产生 创建JS视图对象 的JS代码
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function InitializeJS_ConstructView()
	{
		$sViewName = $this->GetName() ;
		$sViewVaribleName = $this->GetJSVariableName() ;
		
		print "var {$sViewVaribleName} = new JCAT.MVC.View('{$sViewName}') ;\r\n" ;
	}
	
	/**
	 * 产生 JS视图对象 加入 UICtrl 的JS代码
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function InitializeJS_AddUICtrl()
	{
		if( $this->GetUICtrlCount() )
		{
			$sViewVaribleName = $this->GetJSVariableName() ;
				
			print "\r\n// 加入 UICtrl\r\n" ;
			$aIterator = $this->CreateUICtrlIterator() ;
			$aIterator->First() ;
			while( !$aIterator->IsDone() )
			{
				$aUICtrl = $aIterator->Current() ;
				JCAT_ASSERT::ASSERT_INSTANCE($aUICtrl,'JCAT_IJSObject')  ;
				$sUICtrlJSVarName = $aUICtrl->GetJSVariableName() ;
				
				print "if(typeof({$sUICtrlJSVarName})!='undefined'){{$sViewVaribleName}.AddUICtrl({$sUICtrlJSVarName});}\r\n" ;
				
				$aIterator->Next() ;
			}
		}
	}

	
	/**
	 * 产生 加入到父视图 UICtrl 的JS代码
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function InitializeJS_AddToParentView()
	{
		$aParent = $this->GetParent() ;
		if( $aParent and JCAT_Global::IsKindOf($aParent,'JCAT_IView') )
		{
			JCAT_ASSERT::ASSERT_INSTANCE($aParent,'JCAT_IJSObject')  ;
			$sParentVarName = $aParent->GetJSVariableName() ;
			$sViewVaribleName = $this->GetJSVariableName() ;
				
			print "\r\n// 如果父视图已经优先创建, 加入到父视图中\r\n" ;
			print "if( typeof({$sParentVarName})=='object' ){\r\n" ;
			print "	{$sParentVarName}.AddView({$sViewVaribleName}) ;\r\n"  ;
			print "}\r\n" ;
		}
	}
	
	/**
	 * 产生 加入子视图 UICtrl 的JS代码
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function InitializeJS_AddChildrenView()
	{
		if( $this->GetViewCount() )
		{
			print "\r\n// 如果子视图已经优先创建, 加入子视图\r\n" ;
			$aIterator = $this->CreateViewIterator() ;
			$aIterator->First() ;
			while( !$aIterator->IsDone() )
			{
				$sViewVaribleName = $this->GetJSVariableName() ;
			
				$aChildView = $aIterator->Current() ;
				JCAT_ASSERT::ASSERT_INSTANCE($aChildView,'JCAT_IJSObject')  ;
				$sChildViewVarName = $aChildView->GetJSVariableName() ;
				
				print "if( typeof({$sChildViewVarName})=='object' ){\r\n" ;
				print "{$sViewVaribleName}.AddView({$sChildViewVarName});\r\n" ;
				print "}\r\n" ;
				
				$aIterator->Next() ;
			}
		}
	}
	
	/**
	 * 设置对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @param	$aCSSTheme		JCAT_CSSTheme	PropertyDescription
	 * @return	void
	 */
	public function SetCSSTheme(JCAT_CSSTheme $aCSSTheme)
	{
		$this->aCSSTheme = $aCSSTheme ;
	}
	
	/**
	 * 取得对象属性 self::$aCSSTheme
	 *
	 * @access	public
	 * @return	JCAT_CSSTheme
	 */
	public function GetCSSTheme()
	{
		return $this->aCSSTheme ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////


	static private $aShareGlobalUI ;
		
	private $sTemplate ;
	
	
	/**
	 * 
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bEnableView = true ;
	
	static private $sViewGlabalIdx = 0 ;
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		JCAT_CSSTheme
	 */
	private $aCSSTheme ;

	
	/**
	 * 显示所使用的模板文件路径（用户调试）
	 * 
	 * @access	public
	 * @static
	 * @var		bool
	 */
	static public $bShowTemplateFile = false ;
}

?>