<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlForm.php 1800 2009-05-09 11:49:46Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ViewHtmlForm extends JCAT_ViewHtml implements JCAT_IViewForm
{
	/**
	 * 
	 *
	 * @access	public
	 * @param	$aUserRequest=null		JCAT_Request	用户请求
	 * @param	$bForChildren=true		bool			调用子视图
	 * @return	void
	 */
	public function SetDataFromSubmited(JCAT_Request $aUserRequest=null,$bForChildren=true)
	{
		if(!$aUserRequest)
		{
			$aUserRequest = JCAT_Request::GetGlobalInstance() ;
		}
		
		$aIterator = $this->CreateUICtrlIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aUICtrl = $aIterator->Current() ;
			
			if( JCAT_Global::HasImplementedTo($aUICtrl,'JCAT_IUICtrlForm') )
			{
				$aUICtrl->SetDataFromSubmited($aUserRequest) ;
			}
			
			$aIterator->Next() ;
		}
		
		// 子视图
		if( $bForChildren )
		{
			$aViewIterator = $this->CreateViewIterator() ;
			$aViewIterator->First() ;
			while( !$aViewIterator->IsDone() )
			{
				$aChildView = $aViewIterator->Current() ;
				
				if( JCAT_Global::IsKindOf($aChildView,'JCAT_ViewHtmlForm') )
				{
					$aChildView->SetDataFromSubmited($aUserRequest,true) ;
				}
				
				$aViewIterator->Next() ;
			}
		}
	}
	

	
	
	
	/**
	 * 是否有用户提交表单
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsSubmitingForm()
	{
		return !empty($_REQUEST[ $this->GetFormSubmitSign(true) ]) ;
	}	
	
	/**
	 * 获得 Submit Sign
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetFormSubmitSign( $bOnlyName=false )
	{
		if( $bOnlyName )
		{
			return "Submit_For_".$this->GetName() ;
		}

		else
		{
			return "<input type=\"hidden\" name=".$this->GetFormSubmitSign(true)." value='1' />" ;
		}
	}
	
	
	/**
	 * 产生 创建JS视图对象 的JS代码
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function InitializeJS_ConstructView()
	{
		$sViewName = $this->GetName() ;
		$sViewVaribleName = $this->GetJSVariableName() ;
		$sFormName = $this->GetFormName() ;
		
		print "var {$sViewVaribleName} = new JCAT.MVC.View.ViewForm('{$sViewName}','{$sFormName}') ;\r\n" ;
	}

	/**
	 * 提供表单名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetFormName()
	{
		return $this->GetName().'Form' ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bShow=true
	 * @return	void
	 */
	public function ShowForm($bShow=true)
	{
		$this->bShowForm = $bShow? true: false ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsShowForm()
	{
		return $this->bShowForm ;
	}
	
	// 属性 /////////////////////////////////////////////////////////
	private $bShowForm = true ;
}
?>