<?php 
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ViewHtmlForm.php 1800 2009-05-09 11:49:46Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 视图类 JCAT_ViewHtmlList 
 *
 * @access public
 */
class JCAT_ViewHtmlList extends JCAT_ViewHtml 
{
	

	/**
	 * 
	 * @access	public
	 * @param	$sName			string					视图名称
	 * @param	$aParent		JCAT_IViewContainer		父视图 或 控制器
	 * @param	$sTemplate		string					模板文件名称
	 * @param	$aUI=null		JCAT_UIHtml				UI 对象
	 * @return	void
	 */
	public function JCAT_ViewHtmlList( $sTemplate, JCAT_IViewContainer $aParent, $sName=null, JCAT_UIHtml $aUI=null )
	{
		// 调用父类构造函数 
		$this->JCAT_ViewHtml($sTemplate,$aParent,$sName,$aUI) ;

		$this->Initialize() ;	
	}

	/**
	 * 初始化 视图 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		$aMessageHistoryListPagination = new JCAT_UICtrlHtmlPagination('ListPagination','JCAT_DynamicSlidingWindow') ;
		$this->AddUICtrl($aMessageHistoryListPagination) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aDocument	JCAT_IDocument	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetModel( JCAT_IModel $aModel )
	{
		$aMessageHistoryListPagination = $this->GetUICtrl('ListPagination') ;
		$aModel->SetPagination($aMessageHistoryListPagination) ;
		
		return parent::SetModel($aModel) ;
	}

}

?>