<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Webpage.php 1749 2009-04-27 17:48:00Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_Webpage extends JCAT_ViewHtml
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$aParent		JCAT_IViewContainer		父视图 或 控制器
	 * @param	$aUI=null		JCAT_IUIHtml			UI 对象
	 * @return	void
	 */
	public function JCAT_Webpage( JCAT_IViewContainer $aParent, JCAT_IViewHtml $aBodyView=null, JCAT_IUIHtml $aUI=null )
	{
		$this->JCAT_ViewHtml('template.JCAT_WebpageCommon.html',$aParent,'HTMLWebpage',$aUI) ;
		$aUI = $this->GetUI() ;

		$this->SetBodyView($aBodyView) ;
		$this->SetTitle(self::$sDefaultTitle) ;
		$this->SetDescription(self::$sDefaultDescription) ;
		$this->SetKeywords(self::$sDefaultKeywords) ;

		// add html resource
		JCAT_HTMLResourceBase::Package(JCATPATH.'Lib.js/Files.lst',JCATPATH.'Lib.js/package.JCAT.js') ;
		$aUI->AddHTMLRC(new JCAT_JS(JCATPATH.'Lib.js/package.JCAT.js')) ;
		
		JCAT_HTMLResourceBase::Package(JCATPATH.'Lib.js/MVC/Files.lst',JCATPATH.'Lib.js/MVC/package.MVC.js') ;
		$aUI->AddHTMLRC(new JCAT_JS(JCATPATH.'Lib.js/MVC/package.MVC.js')) ;

		$aUI->AddHTMLRC(new JCAT_CSS('JCAT.css')) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @static
	 * @return	void
	 */
	static public function Display($BodyView,$aParent=null,$sTitle=null,$sKeywords=null,$sDescription=null)
	{
		if(!$aParent)
		{
			$aParent = new JCAT_Controller() ;
		}
		
		
		if(is_string($BodyView))
		{
			$aWebpage = new self($aParent) ;
			$aWebpage->SetBodyHtml($BodyView);
		}
		
		else if(JCAT_Global::HasImplementedTo($BodyView,'JCAT_IViewHtml'))
		{
			$aWebpage = new self($aParent,$BodyView) ;
		}
		
		else
		{
			JCAT_ASSERT::ASSERT_ISTHESE($BodyView,array('string','JCAT_IViewHtml'),JCAT_Language::SentenceEx('参数 $BodyView 必须为字符串 或 JCAT_IViewHtml实例','JCAT',null)) ;
			return ;
		}
		
		if($sTitle)
		{
			$aWebpage->SetTitle($sTitle) ;
		}
		
		if($sKeywords)
		{
			$aWebpage->SetKeywords($sKeywords) ;
		}
		
		if($sDescription)
		{
			$aWebpage->SetDescription($sDescription) ;
		}
		
		$aWebpage->ShowView() ;
	}

	/**
	 * 设置 刷新
	 *
	 * @access	public
	 * @param	$nSec		int
	 * @param	$sUrl		string
	 * @return	void
	 */
	public function SetRefresh($nSec,$sUrl)
	{
		$this->nRefreshSec = $nSec ;
		$this->sRefreshUrl = $sUrl ;
	}

	/**
	 * 返回 刷新 时间
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetRefreshSecond()
	{
		return $this->nRefreshSec ;
	}
	
	/**
	 * 返回 刷新 url
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetRefreshUrl()
	{
		return $this->sRefreshUrl ;
	}
	
	/**
	 * 设置 刷新
	 *
	 * @access	public
	 * @param	$sUrl			string
	 * @param	$sTarget		string
	 * @return	void
	 */
	public function SetPathBase($sUrl,$sTarget='self')
	{
		$this->sPathBase = $sUrl ;
		$this->sPathBaseTarget = $sTarget ;
	}

	/**
	 * 返回 PathBase
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPathBase()
	{
		return $this->sPathBase ;
	}
	
	/**
	 * 设置 刷新
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPathBaseTarget()
	{
		return $this->sPathBaseTarget ;
	}


	/**
	 * 设置网页标题
	 *
	 * @access	public
	 * @param 	$sTitle		string
	 * @return	void
	 */
	public function SetTitle($sTitle)
	{
		$this->sHtmlTitle = $sTitle ;
	}
	
	/**
	 * 取得网页标题
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTitle()
	{
		return $this->sHtmlTitle ;
	}

	/**
	 * 设置网页关键词
	 *
	 * @access	public
	 * @param 	$sKeywords		string
	 * @return	void
	 */
	public function SetKeywords($sKeywords)
	{
		$this->sHtmlKeywords = $sKeywords ;
	}
	
	/**
	 * 取得网页标题
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetKeywords()
	{
		return $this->sHtmlKeywords ;
	}

	/**
	 * 设置网页描述
	 *
	 * @access	public
	 * @param 	$sDescription		string
	 * @return	void
	 */
	public function SetDescription($sDescription)
	{
		$this->sHtmlDescription = $sDescription ;
	}
	
	/**
	 * 取得网页标题
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDescription()
	{
		return $this->sHtmlDescription ;
	}

	/**
	 * 设置网页 body 视图
	 *
	 * @access	public
	 * @param 	$aBodyView		JCAT_IViewHtml
	 * @return	void
	 */
	public function SetBodyView(JCAT_IViewHtml $aBodyView=null)
	{
		if($aBodyView)
		{
			$this->AddView($aBodyView,self::sBodyViewChildName) ;
		}
		
		else
		{
			$this->RemoveView(self::sBodyViewChildName) ;
		}
		
		if( !$this->GetBodyHtml() and !$this->GetBodyView() )
		{
			$this->SetBodyHtml(JCAT_Language::SentenceEx('该网页没有内容','JCAT',null)) ;
		}
	}
	
	/**
	 * 取得网页 body 视图
	 *
	 * @access	public
	 * @return	JCAT_IViewHtml
	 */
	public function GetBodyView()
	{
		return $this->GetView(self::sBodyViewChildName) ;
	}
	
	/**
	 * 设置对象属性 BodyHtml
	 *
	 * @access	public
	 * @param	$sBodyHtml		string	BodyHtml
	 * @return	void
	 */
	public function SetBodyHtml($sBodyHtml)
	{
		$this->sBodyHtml = $sBodyHtml ;
	}
	
	/**
	 * 取得对象属性 BodyHtml
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetBodyHtml()
	{
		return $this->sBodyHtml ;
	}
	
	// 属性 /////////////////////////////////////////////////
	
	static public $sDefaultTitle = 'JCAT Web Application' ;
	static public $sDefaultDescription = '' ;
	static public $sDefaultKeywords = '' ;
	
	private $sHtmlTitle ;
	
	private $sHtmlDescription ;
	
	private $sHtmlKeywords ;
	
	
	private $nRefreshSec = 0 ;
	private $sRefreshUrl ;
	
	private $sPathBase = '' ;
	private $sPathBaseTarget = 'self' ;
	
	
	/**
	 * 对象属性 BodyHtml
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sBodyHtml = '' ;
	
	/**
	 * 对象属性 Body
	 * 
	 * @access	private
	 * @var		JCAT_IViewHtml
	 */
	private $aBodyView ;
	
	const sBodyViewChildName = 'theBodyView' ;
}

?>