<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ORMRule_TLHasMany.php 1656 2009-04-11 07:24:36Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ORMRule_TLHasMany extends JCAT_ORMRule_TLMultipleBase
{
	const CONFIG_TYPE = 'hasMany' ;

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetConfigType()
	{
		return self::CONFIG_TYPE ;
	}
	
	/**
	 * get child model that is a property of $aModel
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	JCAT_IDBModel
	 */
	public function GetAssocateWith(JCAT_IDBModel $aModel)
	{
		$aChildModel = parent::GetAssocateWith($aModel) ;
	
		// create the child model dynamic
		// ---------------------------------------------
		if(!$aChildModel)
		{
			$aChildModel = $this->OnConstruct($aModel) ;
		}

		// check type
		// ---------------------------------------------
		if ( !JCAT_Global::HasImplementedTo($aChildModel,'JCAT_IDBAggregationModel') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'传入参数 $aModel 的 %s 属性必须是一个实现 JCAT_IDBAggregationModel 的对象'
				, 'JCAT', null
				, $this->GetAssocateWithProperty()
			)) ;
		}
		
		return $aChildModel ;
	}
	
	/**
	 * action for construction
	 *
	 * @access	public
	 * @return	void
	 */
	public function OnConstruct(JCAT_IDBModel $aModel)
	{
		// 已经被创建
		if( parent::GetAssocateWith($aModel) )
		{
			return ;
		}
		
		$aORM = new JCAT_ORM($aModel->GetORM()->GetDB()) ;
		$aORM->InitFromConfig(array(
			'hub' => array(
				'table' => $this->GetTableName() 
			) 
		)) ;
		
		// create property model
		$aChildModel = JCAT_DBAggregationModel::CreateByORM($aORM) ;
		
		// set to parent model
		$aModel->AddModel($aChildModel,$this->GetAssocateWithProperty()) ;
		
		return $aChildModel ;
	}
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel					JCAT_IDBModel
	 * @param	JCAT_DBSQLInsert		$aSQLInsert
	 * @return	void
	 */
	public function InsertPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLInsert $aSQLInsert)
	{
		// do thing ...
	}
	
	
	/**
	 * before select, ORM will make a sql select by evrey ORMRule's OnSelectPreprocess() method
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aSQLSelect		JCAT_DBSQLSelect
	 * @return	void
	 */
	public function SelectPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLSelect $aSQLSelect)
	{
		// do nothing
	}
		
	/**
	 * action for select
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aRecordSet		JCAT_DBRecordSet
	 * @return	void
	 */
	public function OnAfterSelect(JCAT_IDBModel $aModel,JCAT_DBRecordSet $aRecordSet)
	{
		JCAT_ASSERT::ASSERT_( 
				!JCAT_Global::HasImplementedTo($aModel,'JCAT_IDBAggregationModel')
				, JCAT_Language::SentenceEx('参数 $aModel 不能是一个 JCAT_IDBAggregationModel 模型。','JCAT',null)
		) ;
		
		$sFKFrom = $this->GetForeignKeyFrom() ;
		$sFKTo = $this->GetForeignKeyTo() ;
		
		$sFKFromValue = $aModel->Get($sFKFrom) ;
		JCAT_ASSERT::ASSERT_NOTNULL($sFKFromValue,JCAT_Language::SentenceEx('无法从模型中获得外键(foreign key from)信息。','JCAT',null)) ;
		 
		
		// load linked table
		$aAggModel = $this->GetAssocateWith($aModel) ;
		$aAggModel->FindBy($sFKTo,$sFKFromValue);
		$aAggModel->Load() ;
	}

	
}
?>