<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ORMRule_TLHasOne.php 1723 2009-04-21 11:25:31Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ORMRule_TLHasOne extends JCAT_ORMRule_TLSingleBase
{
	const CONFIG_TYPE = 'hasOne' ;


	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetConfigType()
	{
		return self::CONFIG_TYPE ;
	}
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel					JCAT_IDBModel
	 * @param	JCAT_DBSQLInsert		$aSQLInsert
	 * @return	void
	 */
	public function InsertPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLInsert $aSQLInsert)
	{
		
	}
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$nInsertId		int
	 * @return	void
	 */
	public function OnAfterInsert(JCAT_IDBModel $aModel,$nInsertId)
	{
		$aAssocateModel = $this->GetAssocateWith($aModel) ;

		$sForeignKeyFrom = $this->GetForeignKeyFrom() ;
		$sForeignKeyTo = $this->GetForeignKeyTo() ;

		$sForeignKeyFromValue = $aModel->Get($sForeignKeyFrom) ;
		JCAT_ASSERT::ASSERT_NOTNULL($sForeignKeyFromValue) ;

		// 为模型设置外键
		$aAssocateModel->Set($sForeignKeyTo,$sForeignKeyFromValue,true,false) ;

		// 将外键值设置到 sql insert
		$aAssocateModel->Serialize() ;
	}
	
	/**
	 * action for update
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLUpdate		JCAT_DBSQLUpdate
	 * @return	void
	 */
	public function OnUpdate(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLUpdate $aSQLUpdate)
	{
		// 保存关联表
		$aAssocateModel = $this->GetAssocateWith($aModel) ;
		$aAssocateModel->Save() ;
	}
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLDelete		JCAT_DBSQLDelete
	 * @return	void
	 */
	public function OnDelete(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLDelete $aSQLDelete)
	{
		// 删除关联表
		$aAssocateModel = $this->GetAssocateWith($aModel) ;
		$aAssocateModel->Delete() ;
	}
	
}
?>