<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ORMRule_TLMultipleBase.php 1653 2009-04-10 11:14:29Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_ORMRule_TLMultipleBase extends JCAT_ORMRule_TableLinkBase implements JCAT_IORMRule_TLMultipleAssociation
{	
	
	/**
	 * action for update
	 *
	 * @access	protected
	 * @param	$aModel			JCAT_IDBModel
	 * @return	void
	 */
	protected function CreateAndSave(JCAT_IDBModel $aModel,$sForeignKeyFrom,$sForeignKeyTo)
	{
		// 设置外键
		$sForeignKeyFromValue = $aModel->Get($sForeignKeyFrom) ;
		JCAT_ASSERT::ASSERT_( $sForeignKeyFromValue!=JCAT_Model::NULL_DATA_VALUE )  ;
		
		$aAggModel = $this->GetAssocateWith($aModel) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAggModel,'JCAT_IAggregationModel') ;
		
		$aIter = $aAggModel->CreateModelIterator() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aChildModel = $aIter->Current() ;
			
			// 设置
			if( $sForeignKeyFromValue!=$aChildModel->Get($sForeignKeyTo) )
			{
				$aChildModel->Set($sForeignKeyTo,$sForeignKeyFromValue) ;
				
				// 保存
				$aChildModel->Serialize() ;
			}
		}
	}
	
	
	/**
	 * action for update
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLUpdate		JCAT_DBSQLUpdate
	 * @return	void
	 */
	public function OnUpdate(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLUpdate $aSQLUpdate)
	{
		$this->CreateAndSave($aModel,$this->GetForeignKeyFrom(),$this->GetForeignKeyTo()) ;		
	}
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$nInsertId		int
	 * @return	void
	 */
	public function OnAfterInsert(JCAT_IDBModel $aModel,$nInsertId)
	{
		$this->CreateAndSave($aModel,$this->GetForeignKeyFrom(),$this->GetForeignKeyTo()) ;	
	}


	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLDelete		JCAT_DBSQLDelete
	 * @return	void
	 */
	public function OnDelete(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLDelete $aSQLDelete)
	{
		$aAssocateModel = $this->GetAssocateWith($aModel) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAssocateModel,'JCAT_IAggregationModel') ;
		
		$aAssocateModel->Delete() ;
	}
}

?>