<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ORMRule_TLSingleBase.php 1727 2009-04-22 10:06:27Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_ORMRule_TLSingleBase extends JCAT_ORMRule_TableLinkBase implements JCAT_IORMRule_TLSingleAssociation
{	
	/**
	 * get child model that is a property of $aModel
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	JCAT_IDBModel
	 */
	public function GetAssocateWith(JCAT_IDBModel $aModel)
	{
		$aChildModel = parent::GetAssocateWith($aModel) ;
		
		// create the child model dynamic
		// ---------------------------------------------
		if(!$aChildModel)
		{
			$aChildModel = $this->OnConstruct($aModel) ;
		}

		// check type
		// ---------------------------------------------
		if ( JCAT_Global::HasImplementedTo($aChildModel,'JCAT_IDBAggregationModel') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'传入参数 $aModel 的 %s 属性不能是一个 JCAT_IDBAggregationModel 对象'
				, 'JCAT', null
				, $this->GetAssocateWithProperty()
			)) ;
		}
		
		return $aChildModel ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	void
	 */
	public function GetAssocateORM(JCAT_IDBModel $aModel)
	{
		$aChildModel = parent::GetAssocateWith($aModel) ;
		
		// create the child model dynamic
		// ---------------------------------------------
		if(!$aChildModel)
		{
			return $this->CreateAssocateORM($this->GetTableName(),$aModel->GetORM()->GetDB()) ;
		}
		
		else
		{
			return $aChildModel->GetORM() ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	JCAT_ORM
	 */
	private function CreateAssocateORM($sTableName,JCAT_DB $aDB)
	{
		$aORM = new JCAT_ORM($aDB) ;
		$aORM->InitFromConfig(array(
			'hub' => array(
				'table' => $sTableName
			) 
		)) ;
		
		return $aORM ;
	}

	
	/**
	 * action for construction
	 *
	 * @access	public
	 * @return	void
	 */
	public function OnConstruct(JCAT_IDBModel $aModel)
	{
		// 已经被创建
		if( parent::GetAssocateWith($aModel) )
		{
			return ;
		}
		
		$aORM = $this->CreateAssocateORM($this->GetTableName(),$aModel->GetORM()->GetDB()) ;
		
		// create property model
		$aChildModel = JCAT_DBModel::CreateByORM($aORM) ;
		
		// set to parent model
		$aModel->AddModel($aChildModel,$this->GetAssocateWithProperty()) ;
		
		return $aChildModel ;
	}
	
	/**
	 * before select, ORM will make a sql select by evrey ORMRule's OnSelectPreprocess() method
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aSQLSelect		JCAT_DBSQLSelect
	 * @return	void
	 */
	public function SelectPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLSelect $aSQLSelect)
	{
		// 添加表和字段
		$aAssORM = $this->GetAssocateORM($aModel) ;
		$aFieldsRule = $aAssORM->GetFieldsMappingRule() ;
		$aFieldsRule->SelectPreprocess($aModel,$aSQLSelect) ;
		
		// 添加外键
		$aWhere = $aSQLSelect->GetSubSQLWhere() ;
		$aWhere->AddCondition(
				JCAT_DB::E($this->GetTableName().'.'.$this->GetForeignKeyFrom())
				, JCAT_DB::E($this->GetLinkedTableName().'.'.$this->GetForeignKeyTo())
		) ;
	}
		
	/**
	 * action for select
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aRecordSet		JCAT_DBRecordSet
	 * @return	void
	 */
	public function OnAfterSelect(JCAT_IDBModel $aModel,JCAT_DBRecordSet $aRecordSet)
	{
		JCAT_ASSERT::ASSERT_( 
				!JCAT_Global::HasImplementedTo($aModel,'JCAT_IDBAggregationModel')
				, JCAT_Language::SentenceEx('参数 $aModel 不能是一个 JCAT_IDBAggregationModel 模型。','JCAT',null)
		) ;

		// load linked table
		$aAssModel = $this->GetAssocateWith($aModel) ;
		$aAssORM = $aAssModel->GetORM() ;
		$aFieldsRule = $aAssORM->GetFieldsMappingRule() ;
		$aFieldsRule->OnAfterSelect($aAssModel,$aRecordSet) ;
		
		$aAssModel->SetSerialized(true) ;
	}
}

?>