<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ORM_Action.php 1720 2009-04-21 03:39:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_ORM_Action
{
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function SeSQLWhere(JCAT_IDBModel $aModel,JCAT_DBSQLRecordsOperate $aSQL)
	{
		$aDBFactory = $aSQL->GetFactory() ;
		$aSubSQLWhere = $aSQL->GetSubSQLWhere() ;
		$aIterator = $aModel->CreateConditionIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$Item = $aIterator->Current();
			
			if( is_array($Item) )
			{
				@list($sField,$sData,$sOperator,$RightB) = $Item ;				
				$aSubSQLWhere->AddCondition($aDBFactory->CreateColumn($sField),$sData,$sOperator,$RightB) ;
			}
			
			else if( is_string($Item) )
			{
				$aSubSQLWhere->AddStringCondition($Item) ;
			}
			
			else
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'遇到未知类型的数据库查询条件。', 'JCAT', null
				)) ;
			}
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aModel				JCAT_IDBModel
	 * @param	$aORM				JCAT_ORM
	 * @return	void
	 */
	public function Construct(JCAT_IDBModel $aModel,JCAT_ORM $aORM)
	{
		// process by rules
		$aRuleIterator = $aORM->CreateORMRuleIterator() ;
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			$aRule->OnConstruct($aModel) ;
		}
	}
	
	/**
	 * action for insert or update
	 *
	 * @access	public
	 * @param	$aModel				JCAT_IDBModel
	 * @param	$aORM				JCAT_ORM
	 * @return	bool
	 */
	public function Insert(JCAT_IDBModel $aModel,JCAT_ORM $aORM)
	{
		$aDB = $aORM->GetDB() ;
		$aDBFactory = $aDB->GetFactory() ;
		
		// create a db transaction
		$aSQLInsert = $aDBFactory->CreateSQLInsert() ;
		
		// process by rules
		$aRuleIterator = $aORM->CreateORMRuleIterator() ;
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			$aRule->InsertPreprocess($aModel,$aSQLInsert) ;
		}
		
		// execute
		if( !$aDB->Query($aSQLInsert) )
		{
			return false ;
		}
		
		$nInsertId = $aDB->GetConnect()->GetInsertID() ;
		
		//  OnAfterInsert()
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			$aRule->OnAfterInsert($aModel,$nInsertId) ;
		}
		
		return true ;
	}

	/**
	 * action for insert or update
	 *
	 * @access	public
	 * @param	$aModel				JCAT_IDBModel
	 * @param	$aORM				JCAT_ORM
	 * @return	bool
	 */
	public function Update(JCAT_IDBModel $aModel,JCAT_ORM $aORM)
	{
		$aDB = $aORM->GetDB() ;
		$aDBFactory = $aDB->GetFactory() ;
		
		// create a db transaction
		$aDBTrans = $aDBFactory->CreateTransaction() ;

		// create update
		$aSQLUpdate = $aDBFactory->CreateSQLUpdate() ;
		$aDBTrans->AddCommand($aSQLUpdate) ;
		
		// process by rules
		$aRuleIterator = $aORM->CreateORMRuleIterator() ;
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			$aRule->OnUpdate($aModel,$aDBTrans,$aSQLUpdate) ;
		}
		
		// commit transaction
		return $aDBTrans->Execute($aDB->GetConnect()) ;
	}
	
	

	/**
	 * action for select
	 *
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @param	$aORM			JCAT_ORM
	 * @return	bool
	 */
	public function Select(JCAT_IDBModel $aModel,JCAT_ORM $aORM)
	{
		$aDB = $aORM->GetDB() ;
		$aDBFactory = $aDB->GetFactory() ;
		$bIsAggregationModel = JCAT_Global::HasImplementedTo($aModel,'JCAT_IAggregationModel') ;
		
		// create sql select
		$aSQLSelect = $aDBFactory->CreateSQLSelect() ;

		// set condition to find which row will being select ...
		$this->SeSQLWhere($aModel,$aSQLSelect) ;
	
		
		// preprocess, to compose a select sql by orm rules
		$aRuleIterator = $aORM->CreateORMRuleIterator() ;
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			
			// processing
			$aRule->SelectPreprocess($aModel,$aSQLSelect) ;
		}
		
		// set row limit 
		$aSubSQLLimit = $aSQLSelect->GetSubSQLLimit() ;
		if( $bIsAggregationModel )
		{
			$aSubSQLLimit->SetLimit(
					$aModel->GetCountPerPage()
					, $aModel->GetStartPos() ) ;
		}
		
		// just one row
		else 
		{
			$aSubSQLLimit->SetLimit(1) ;
		}
		
		// Order by
		$aSubSQLOrder = $aORM->GetSubSQLOrder() ;
		if( $aSubSQLOrder )
		{
			$aSQLSelect->SetSubSQLOrder($aSubSQLOrder) ;
		}
		
		// select operation
		$aRecordSet = $aDBFactory->CreateRecordSet($aDB->GetConnect()) ;
		
		if( !$aRecordSet->Query($aSQLSelect) )// if occur error , a exception throw out
		{
			return false ;
		}
		
		if( $bIsAggregationModel )
		{
			// query total rows count
			$aSQLSelect->GetSubSQLLimit()->SetLimit(-1);
			$nTotal = $aORM->GetDB()->GetConnect()->GetSelectCount($aSQLSelect) ;
		
			// load to model
			$aModel->LoadFromRecordset($aRecordSet,$nTotal) ;
		}

		else 
		{
			if($aRecordSet->GetCount()===0)
			{
				return false ;
			}
			
			// load to model
			$aORM->LoadModelByRules($aModel,$aRecordSet,$aRuleIterator) ;
		}
		
		return true ;
	}

	/**
	 * action for insert or update
	 *
	 * @access	public
	 * @param	$aModel				JCAT_IDBModel
	 * @param	$aORM					JCAT_ORM
	 * @return	bool
	 */
	public function Delete(JCAT_IDBModel $aModel,JCAT_ORM $aORM)
	{
		$aDB = $aORM->GetDB() ;
		$aDBFactory = $aDB->GetFactory() ;
		
		// create a db transaction
		$aDBTrans = $aDBFactory->CreateTransaction() ;
		
		// create sql delete
		$aSQLDelete = $aDBFactory->CreateSQLDelete() ;

		// TODO : set condition to find which row will being deleted ...
		
		$aDBTrans->AddCommand($aSQLDelete) ;
		
		// process by rules
		$aRuleIterator = $aORM->CreateORMRuleIterator() ;
		for ( $aRuleIterator->First(); !$aRuleIterator->IsDone(); $aRuleIterator->Next() )
		{
			$aRule = $aRuleIterator->Current() ;
			
			$aRule->OnDelete($aModel,$aDBTrans,$aSQLDelete) ;
		}
		
		// commit transaction
		return $aDBTrans->Execute($aDB->GetConnect()) ;
	}
}


?>