<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IORMRule.php 1646 2009-04-10 08:59:12Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IORMRule
{
	/**
	 * construct
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @param	$aDBFactory		JCAT_IDBFactory
	 * @return	void
	 */
	public function __construct($sTableName,JCAT_DBAbstractFactory $aDBFactory) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetConfigType() ;
	
	/**
	 * action for construction
	 *
	 * @access	public
	 * @return	void
	 */
	public function OnConstruct(JCAT_IDBModel $aModel) ;
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel					JCAT_IDBModel
	 * @param	JCAT_DBSQLInsert		$aSQLInsert
	 * @return	void
	 */
	public function InsertPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLInsert $aSQLInsert) ;	
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$nInsertId		int
	 * @return	void
	 */
	public function OnAfterInsert(JCAT_IDBModel $aModel,$nInsertId) ;	
	
	/**
	 * before select, ORM will make a sql select by evrey ORMRule's OnSelectPreprocess() method
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aSQLSelect		JCAT_DBSQLSelect
	 * @return	void
	 */
	public function SelectPreprocess(JCAT_IDBModel $aModel,JCAT_DBSQLSelect $aSQLSelect) ;
		
	/**
	 * action for select
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aRecordSet		JCAT_DBRecordSet
	 * @return	void
	 */
	public function OnAfterSelect(JCAT_IDBModel $aModel,JCAT_DBRecordSet $aRecordSet) ;	
	
	/**
	 * action for update
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLUpdate		JCAT_DBSQLUpdate
	 * @return	void
	 */
	public function OnUpdate(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLUpdate $aSQLUpdate) ;
	
	/**
	 * action for delete
	 *
	 * @access	public
	 * @param	$aModel			JCAT_IDBModel
	 * @param	$aDBTrans		JCAT_IDBTransaction
	 * @param	$aSQLDelete		JCAT_DBSQLDelete
	 * @return	void
	 */
	public function OnDelete(JCAT_IDBModel $aModel,JCAT_IDBTransaction $aDBTrans,JCAT_DBSQLDelete $aSQLDelete) ;
	
	/**
	 * set the table name
	 *
	 * @access	public
	 * @param	$sTableName
	 * @return	void
	 */
	public function SetTableName($sTableName) ;
	
	/**
	 * get the table name
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTableName() ;
	
	
}

?>