<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: -class.JCAT_ORMRuleBase.php 1627 2009-04-03 10:07:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_ORMRuleBase implements JCAT_IORMRule
{

	/**
	 * construct
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @param	$sRuleType		string
	 * @param	$aDBFactory		JCAT_IDBFactory
	 * @return	void
	 */
	public function __construct($sTableName,$sRuleType,JCAT_DBAbstractFactory $aDBFactory)
	{
		$this->SetTableName($sTableName) ;
		$this->aDBFactory = $aDBFactory ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetType()
	{
		return $this->sRuleType ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$sTableName 	string
	 * @return	string
	 */
	public function SetTableName($sTableName)
	{
		$this->sTableName = $sTableName ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTableName()
	{
		return $this->sTableName ;
	}
	
	/**
	 * get the factory of db object
	 *
	 * @access	public
	 * @return	JCAT_IDBAbstractFactory
	 */
	public function GetDBFactory()
	{
		return $this->aDBFactory ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrConf	array
	 * @static 
	 * @return	array
	 */
	static public function TidyORMConfArray(array $arrConf,array $arrAliases=array())
	{
		$arrNewConf = array() ;
		foreach ($arrConf as $sKey=>$Value)
		{
			// 变为小写
			$sKey = strtolower($sKey) ;
			$arrNewConf[$sKey] = $Value ;
		}
		
		// 别名
		foreach ($arrAliases as $sAlias=>$sKey)
		{
			if( array_key_exists($sAlias,$arrNewConf) )
			{
				$arrNewConf[$sKey] = $arrNewConf[$sAlias] ;
			}
		}
		
		return $arrNewConf ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$arrConf		array
	 * @param	$arrNotnulls	array
	 * @return	void
	 */
	protected function CheckORMConfArray(array $arrConf,array $arrNotnulls)
	{
		foreach( $arrNotnulls as $sKey )
		{
			if( !isset($arrConf[$sKey]) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'%s 类型的ORM配置中缺少必要的内容 %s'
					, 'JCAT', null, $this->GetConfigType(), $sKey
				)) ;
			}
		}
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sTableName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IDBAbstractFactory
	 */
	private $aDBFactory ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sRuleType ;
	
}
?>