<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: -class.JCAT_ORMRule_TLHasAndBelongsToMany.php 1627 2009-04-03 10:07:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ORMRule_TLHasAndBelongsToMany  implements JCAT_IORMRule_TLMultipleAssociation 
{	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrORMConfAlias = array(
			'fktobridge' => 'foreignkeytobridge'
			, 'fkfrombridge' => 'foreignkeyfrombridge'
	) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @array	$arrConfig			array
	 * @array	$aDB				JCAT_DB
	 * @static
	 * @return	JCAT_IORMRule
	 */
	public function InitFromConfig(array $arrConfig,JCAT_DB $aDB)
	{
		$arrConfig = JCAT_ORMRuleBase::TidyORMConfArray($arrConfig,self::$arrORMConfAlias) ;
		$this->CheckORMConfArray($arrConfig,array('foreignkeytobridge','foreignkeyfrombridge','bridgetable')) ;
		
		$this->SetForeignKey($arrConfig['foreignkeytobridge'],'toBridge') ;
		$this->SetForeignKey($arrConfig['foreignkeyfrombridge'],'fromBridge') ;

		$this->SetBridgeTableName($arrConfig['bridgetable']) ;
		
		// call parent
		parent::InitFromConfig($arrConfig,$aDB) ;		
	}
	
	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function SetForeignKeyFromBridge($sForeignKey)
	{
		$this->SetForeignKey($sForeignKey,'fromBridge') ;
	}
	
	/**
	 *
	 * @access	public
	 * @param 	$sForeignKey		string
	 * @return	string
	 */
	public function SetForeignKeyToBridge($sForeignKey)
	{
		$this->SetForeignKey($sForeignKey,'toBridge') ;
	}
	
	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyToBridge()
	{
		return $this->GetForeignKey('toBridge') ;
	}
	
	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyFromBridge()
	{
		return $this->GetForeignKey('fromBridge') ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTableName
	 * @return	void
	 */
	public function SetBridgeTableName($sTableName)
	{
		$this->sBridgeTable = $sTableName ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetBridgeTableName()
	{
		return $this->sBridgeTable ;
	}
	
	/**
	 * get child model that is a property of $aModel
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	JCAT_IDBModel
	 */
	public function GetAssocateWith(JCAT_IDBModel $aModel)
	{
		$aChildModel = parent::GetAssocateWith($aModel) ;
	
		// create the child model dynamic
		// ---------------------------------------------
		if(!$aChildModel)
		{
			$aORM = new JCAT_ORM($aModel->GetORM()->GetDB()) ;
			$aORM->InitFromConfig(array(
				'hub' => array(
					'table' => $this->GetBridgeTableName()
				) 
				
				, 'belongsTo' => array(
					array(
						'table' => $this->GetTableName()
						, 'fkFrom' => $this->GetForeignKeyFromBridge()
						, 'property' => 'belongsTo:'.$this->GetTableName()
					)				
				)
			)) ;
			
			// create property model
			$aChildModel = call_user_func_array(
						array('JCAT_DBAggregationModel','CreateByORM')
						,array($aORM)
			) ;
			
			// set to parent model
			$aModel->AddModel($aChildModel,$this->GetAssocateWithProperty()) ;
		}

		// check type
		// ---------------------------------------------
		if ( !JCAT_Global::HasImplementedTo($aChildModel,'JCAT_IDBAggregationModel') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'传入参数 $aModel 的 %s 属性必须是一个实现 JCAT_IDBAggregationModel 的对象'
				, 'JCAT', null
				, $this->GetAssocateWithProperty()
			)) ;
		}
		
		return $aChildModel ;
	}

	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sBridgeTable ;
}
?>