<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: -class.JCAT_ORMRule_TableLinkBase.php 1627 2009-04-03 10:07:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_ORMRule_TableLinkBase extends JCAT_ORMRuleBase implements JCAT_IORMRule_TableLink
{
	/**
	 * construct
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @param	$sRuleType		string
	 * @param	$aDBFactory		JCAT_IDBFactory
	 * @return	void
	 */
	public function __construct($sTableName,$sRuleType,JCAT_DBAbstractFactory $aDBFactory)
	{
		parent::__construct($sTableName,$sRuleType,$aDBFactory) ;
		$this->aSelectJoinOn = $aDBFactory->CreateSubSQLOn() ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrORMConfAlias = array(
			'fkto' => 'foreignkeyto'
			, 'fkfrom' => 'foreignkeyfrom'
	) ;

	
	/**
	 * Description
	 *
	 * @access	public
	 * @array	$arrConfig		array
	 * @array	$aDB				JCAT_DB
	 * @static
	 * @return	JCAT_IORMRule
	 */
	public function InitFromConfig(array $arrConfig,JCAT_DB $aDB)
	{
		$arrConfig = JCAT_ORMRuleBase::TidyORMConfArray($arrConfig,self::$arrORMConfAlias) ;
		
		// default 
		if(empty($arrConfig['foreignkeyfrom']))
		{
			JCAT_ASSERT::ASSERT_( isset($arrConfig['hubtable']), "ORMConf array no hubtable" ) ;
			$aDBReflector = $aDB->GetConnect()->GetDBReflector() ;
			$arrConfig['foreignkeyfrom'] = $aDBReflector->GetPrimaryKey($arrConfig['hubtable']) ;
		}
		if(empty($arrConfig['foreignkeyto']))
		{
			$aDBReflector = $aDB->GetConnect()->GetDBReflector() ;
			$arrConfig['foreignkeyto'] = $aDBReflector->GetPrimaryKey($arrConfig['table']) ;
		}
		
		// check not null content
		$this->CheckORMConfArray($arrConfig,array('hubtable','property','foreignkeyfrom','foreignkeyto')) ;
		
		
		// set linked table
		$this->SetLinkedTableName($arrConfig['hubtable']);
		
		// set foreign key
		// ----------------------------------------------------------------------------------		
		$this->SetForeignKey($arrConfig['foreignkeyfrom'],'from') ;		
		$this->SetForeignKey($arrConfig['foreignkeyto'],'to') ;
		
		// set map to property name
		// ----------------------------------------------------------------------------------
		if(empty($arrConfig['property']))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'%s 类型的ORM配置中缺少必要的内容 property'
				, 'JCAT', null, self::GetConfigType()
			)) ;
		}		
		$this->SetAssocateWith($arrConfig['property']) ;		
	}
	
	
	/**
	 * set a property name, will used for find a child model(ModelB) in the ModelA (ModelA is passed by ORM when OnSelect(), OnInsert() ...)
	 * this object map the relation between two db tables to the ModelA and ModelB,
	 *  if $sProperty==self::MODEL_SELF , means ModelA and ModelB is same object, and db tables relation will map to 'is a' oop relation .
	 *  if not, means map to 'has a' oop relation 
	 * 
	 * @access	public
	 * @param	$sProperty
	 * @return	void
	 */
	public function SetAssocateWith($sProperty=JCAT_IORMRule_TableLink::MODEL_SELF)
	{
		$this->sProperty = $sProperty ;
	}
	
	
	/**
	 * get child model that is a property of $aModel
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	JCAT_IDBModel
	 */
	public function GetAssocateWith(JCAT_IDBModel $aModel)
	{
		return ($this->sProperty===JCAT_IORMRule_TableLink::MODEL_SELF)?
							$aModel: $aModel->GetModel($this->sProperty) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetAssocateWithProperty()
	{
		return $this->sProperty ;
	}
	
	/**
	 * set linked table name
	 *
	 * @access	public
	 * @param	$sTableName
	 * @return	void
	 */
	public function SetLinkedTableName($sTableName)
	{
		$this->sLinkedTableName = $sTableName ;
	}
	
	/**
	 * get the linked table name
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetLinkedTableName()
	{
		return $this->sLinkedTableName ;
	}
	
	
	/**
	 * return a JCAT_DBSubSQLOn object
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLOn
	 */
	public function GetLinkCondition()
	{
		return $this->aSelectJoinOn ;
	}

	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function SetForeignKeyFrom($sForeignKey)
	{
		$this->SetForeignKey($sForeignKey,'from') ;
	}
	
	/**
	 *
	 * @access	public
	 * @param 	$sForeignKey		string
	 * @return	string
	 */
	public function SetForeignKeyTo($sForeignKey)
	{
		$this->SetForeignKey($sForeignKey,'to') ;
	}
	
	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyTo()
	{
		return $this->GetForeignKey('to') ;
	}
	
	/**
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyFrom()
	{
		return $this->GetForeignKey('from') ;
	}
	
	/**
	 *
	 * @access	protected
	 * @param	$sForeignKey	string		foreign key
	 * @param	$sSide			string
	 * @return	void
	 */
	protected function SetForeignKey($sForeignKey,$sSide)
	{		
		$this->arrForeignKeys[$sSide] = $sForeignKey ;
	}
	
	/**
	 *
	 * @access	protected
	 * @param	$sSide='to'			string
	 * @return	string
	 */
	protected function GetForeignKey($sSide)
	{
		return isset($this->arrForeignKeys[$sSide])? $this->arrForeignKeys[$sSide]: null ;
	}
	
	/**
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrForeignKeys ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sLinkedTableName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sProperty ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLOn
	 */
	private $aSelectJoinOn ;
}

?>