<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: -interface.JCAT_IORMRule_TableLink.php 1627 2009-04-03 10:07:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IORMRule_TableLink
{
	const MODEL_SELF = '!$@' ;
	
	/**
	 * set a property name, will used for find a child model(ModelB) in the ModelA (ModelA is passed by ORM when OnSelect(), OnInsert() ...)
	 * this object map the relation between two db tables to the ModelA and ModelB,
	 *  if $sProperty==self::MODEL_SELF , means ModelA and ModelB is same object, and db tables relation will map to 'is a' oop relation .
	 *  if not, means map to 'has a' oop relation 
	 * 
	 * @access	public
	 * @param	$sProperty
	 * @return	void
	 */
	public function SetAssocateWith($sProperty=self::MODEL_SELF) ;
	
	
	/**
	 * get child model that is a property of $aModel
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IDBModel
	 * @return	JCAT_IDBModel
	 */
	public function GetAssocateWith(JCAT_IDBModel $aModel) ;

	
	/**
	 * set linked table name
	 *
	 * @access	public
	 * @param	$sTableName
	 * @return	void
	 */
	public function SetLinkedTableName($sTableName) ;
	
	/**
	 * get the linked table name
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetLinkedTableName() ;

	
	/**
	 * set foreign key
	 *
	 * @access	public
	 * @param	$sForeignKey		string	foreign key name
	 * @return	void
	 */
	public function SetForeignKeyFrom($sForeignKey) ;
	
	/**
	 * get foreign key
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyFrom() ;
	
	/**
	 * set foreign key
	 *
	 * @access	public
	 * @param	$sForeignKey		string	foreign key name
	 * @return	void
	 */
	public function SetForeignKeyTo($sForeignKey) ;
	
	/**
	 * get foreign key
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetForeignKeyTo() ;
	
	/**
	 * return a JCAT_DBSubSQLOn object
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLOn
	 */
	public function GetLinkCondition() ;
	
}

?>