<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBAdjacensyCategoryTree.php 1703 2009-04-20 11:08:36Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBAdjacensyCategoryTree extends JCAT_DBAggregationModel
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_DBAdjacensyCategoryTree( JCAT_ORM $aORM )
	{
		if( $aORM->GetFieldByProperty(JCAT_DBAdjacensyCategory::BORDER_LEFT)===null 
				or $aORM->GetFieldByProperty(JCAT_DBAdjacensyCategory::BORDER_RIGHT)===null )
		{
		 	throw new JCAT_Exception(JCAT_Language::SentenceEx(
		 		'传递给 邻接分类模型(JCAT_DBAdjacensyCategory)的 ORM对象缺少必须的属性/字段映射（%s,%s）'
		 		, 'JCAT', null ,JCAT_DBAdjacensyCategory::BORDER_LEFT, JCAT_DBAdjacensyCategory::BORDER_RIGHT
		 	)) ;
		}
		
		$this->JCAT_DBAggregationModel($aORM) ;
		$this->SetPrototype('JCAT_DBAdjacensyCategory') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Prototype		null,string,JCAT_DBAdjacensyCategory
	 * @return	void
	 */
	public function SetPrototype($Prototype)
	{
		JCAT_ASSERT::ASSERT_ISTHESE( $Prototype, array('null','JCAT_DBAdjacensyCategory')
					, JCAT_Language::SentenceEx('参数 $Prototype 必须是一个 JCAT_DBAdjacensyCategory 派生类或实例。','JCAT',null) );

		parent::SetPrototype($Prototype) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$bBuildTree=true
	 * @return	bool
	 */
	public function Load($bBuildTree=true)
	{
		// delete root of tree
		$this->aVirtualRootCategory = null ;
		
		if( !parent::Load() )
		{
			return false ; 
		}
		
		// rebuild the tree
		if($bBuildTree)
		{
			$this->BuildTree() ; 
		}
		
		return true ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_DBAdjacensyCategory
	 * @return	void
	 */
	public function AddModel( JCAT_IModel $aModel, $sName=null )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aModel,'JCAT_DBAdjacensyCategory'
			, JCAT_Language::SentenceEx('参数 $aModel 必须为一个JCAT_DBAdjacensyCategory实例','JCAT',null));

		return parent::AddModel($aModel,$aModel->GetLeftBorder()) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aRecordSet			JCAT_DBRecordSet
	 * @param	$aORM				JCAT_ORM
	 * @param	$aChildModel		JCAT_IModel
	 * @return	void
	 */
	public function OnLoadChild(JCAT_DBRecordSet $aRecordSet,JCAT_ORM $aORM,JCAT_IModel $aChildModel)
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aChildModel,'JCAT_DBAdjacensyCategory') ;
		
		$aChildModel->Loading(true) ;
		parent::OnLoadChild($aRecordSet,$aORM,$aChildModel) ;
		$aChildModel->Loading(false) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateTopCategoryIter()
	{
		return $this->aVirtualRootCategory?
					$this->aVirtualRootCategory->CreateModelIterator() :
					new JCAT_NullIterator() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function BuildTree()
	{
		// 排序
		$this->aModelContainer->SortByName() ;
		
		// building
		// ----------------------------
		$aIterator = $this->CreateModelIterator() ;
		
		// create a virtual root category to collect categories
		$this->CreateVirtualRootCategory() ;
		
		// loop other categories
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aCategory = $aIterator->Current() ;			
			$this->aVirtualRootCategory->AddCategory($aCategory) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function CreateVirtualRootCategory()
	{
		$aNewORM = clone $this->GetORM() ;
		$this->aVirtualRootCategory = new JCAT_DBAdjacensyCategory($aNewORM) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_DBAdjacensyCategory
	 */
	public function GetVirtualRootCategory()
	{
		return $this->aVirtualRootCategory ;
	}
	
	/**
	 * 添加一个分类到树中
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddCategory(JCAT_IAdjacensyCategory $aCategory)
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aCategory,'JCAT_DBAdjacensyCategory') ;
		
		if( !$this->aVirtualRootCategory )
		{
			$this->CreateVirtualRootCategory() ;
		}
		
		$this->aVirtualRootCategory->AddCategory($aCategory) ;
		$this->AddModel($aCategory) ;
	}
	
	/**
	 * 递归地移除一个分类
	 *
	 * @access	public
	 * @return	void
	 */
	public function RemoveCategory(JCAT_IAdjacensyCategory $aCategory)
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aCategory,'JCAT_DBAdjacensyCategory') ;
		
		if( $this->aVirtualRootCategory )
		{
			$this->aVirtualRootCategory->RemoveCategory($aCategory) ;
		}
		
		$this->RemoveModel($aCategory) ;
	}
	
	// 属性 ////////////////////////////////////////////////////
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_DBAdjacensyCategory
	 */
	private $aVirtualRootCategory ;
}

?>