<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBAggregationModel.php 1720 2009-04-21 03:39:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBAggregationModel extends JCAT_AggregationModel implements JCAT_IDBAggregationModel
{
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrORMConfig=array()	array, JCAT_ORM
	 * @param	$aDB=null					JCAT_DB
	 * @return	void
	 */
	public function JCAT_DBAggregationModel( $ORMOrConfig=array(), JCAT_DB $aDB=null )
	{
		// call parent construct
		$this->JCAT_AggregationModel() ;
		
		if( is_array($ORMOrConfig) )
		{
			// orm
			$aORM = new JCAT_ORM($aDB) ;
			$aORM->InitFromConfig($ORMOrConfig) ;
			$this->SetORM($aORM) ;
		}
		
		else if (JCAT_Global::IsKindOf($ORMOrConfig,'JCAT_ORM') )
		{
			$this->SetORM($ORMOrConfig) ;
		}
		
		else
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'参数 $ORMOrConfig 必须为 ORM Config 数组 或 ORM 对象'
				, 'JCAT', null
			)) ;
		}
	}
	
	/**
	 * create a db aggregation model by passing a ORM
	 *
	 * @access	public
	 * @param	$aORM			JCAT_ORM
	 * @static
	 * @return	JCAT_DBAggregationModel
	 */
	static public function CreateByORM(JCAT_ORM $aORM)
	{		
		return new self($aORM) ;
	}

	
	/**
	 * 根据主键id取得模型
	 *
	 * @access	public
	 * @param	$nPrimaryId
	 * @return	JCAT_IDBModel
	 */
	public function GetModelById($nPrimaryId)
	{
		$aIterator = $this->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aModel = $aIterator->Current();
			
			if($aModel->GetId()==$nPrimaryId)
			{
				return $aModel ;
			}
		}
		
		return null ;
	}
	
	/**
	 * get db primary key
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPrimaryKey()
	{
		$aORM = $this->GetORM() ;
		JCAT_ASSERT::ASSERT_NOTNULL($aORM,JCAT_Language::SentenceEx('no ORM ?','JCAT',null))  ;
		
		return $aORM->GetPrimaryKey() ;
	}
	
	
	/**
	 * get the primary key value
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetId()
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->GetId(): null ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sFieldName	string	What's this Parameter ?
	 * @return	
	 */
	public function GetByField( $sFieldName )
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->GetByField(): null ;
	}
	
	/**
	 * create a db aggregation model from a prototype db model
	 *
	 * @access	public
	 * @param	$aPrototype			JCAT_IDBModel
	 * @static
	 * @return	JCAT_DBAggregationModel
	 */
	static public function CreateFromPrototype(JCAT_IDBModel $aPrototype)
	{
		$aAggModel = self::CreateByORM($aPrototype->GetORM()) ;
		$aAggModel->SetPrototype($aPrototype) ;
		
		return $aAggModel ;
	}
	
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Prototype		null,string,JCAT_IDBModel
	 * @return	void
	 */
	public function SetPrototype($Prototype)
	{
		// prototype
		JCAT_ASSERT::ASSERT_ISTHESE( $Prototype, array('null','JCAT_IDBModel')
					, JCAT_Language::SentenceEx('参数 $Prototype 必须是一个实现JCAT_IDBModel接口的 类名或实例。','JCAT',null) );
		$this->Prototype = $Prototype ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IDBModel
	 */
	public function CreateChildModel()
	{
		// create a JCAT_DBModel instance
		if( $this->Prototype==null )
		{
			return JCAT_DBModel::CreateByORM($this->GetORM()) ;
		}
		
		// create a special instance
		else if( is_string($this->Prototype) )
		{
			return call_user_func_array( array($this->Prototype,'CreateByORM'), array($this->GetORM()) ) ;
		}
		
		// clone a instance from prototype
		else if( is_object($this->Prototype) )
		{
			return clone $this->Prototype ;
		}
		
		else
		{
			JCAT_ASSERT::ASSERT_(0,'!?') ;
		}
	}

	/**
	 * set ORM
	 *
	 * @access	public
	 * @param 	$aORM		JCAT_ORM
	 * @return	void
	 */
	public function SetORM(JCAT_ORM $aORM)
	{
		$this->aORM = $aORM ;
	}
	
	/**
	 * get ORM
	 *
	 * @access	public
	 * @return	JCAT_ORM
	 */
	public function GetORM()
	{
		return $this->aORM ;
	}

	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __sleep()
	{
		$arrSavePropertys = parent::__sleep() ;
		
		$arrSavePropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('aORM',__CLASS__) ;
		
		return $arrSavePropertys ;
	}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Load()
	{
		$this->GetORM()->Load($this) ;
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$aRecordSet		JCAT_DBRecordSet
	 * @param 	$nTotalCount=0	int
	 * @return	void
	 */
	public function LoadFromRecordset(JCAT_DBRecordSet $aRecordSet,$nTotalCount=0)
	{
		$aORM = $this->GetORM() ;
		
		while( $aRecordSet->GetRow() )
		{
			// create child model
			$aChildModel = $this->CreateChildModel() ;
			
			// load child model
			$this->OnLoadChild($aRecordSet,$aORM,$aChildModel) ;
			
			//append
			$this->AddModel($aChildModel) ;
			
			$aRecordSet->Fetch() ;
		}
		
		// set total count
		$this->SetTotalCount($nTotalCount>0?$nTotalCount:$aRecordSet->GetCount()) ;
		
		// set Pagination 
		$aPagination = $this->GetPagination() ;
		if($aPagination and $nPageCount=$this->GetPageCount())
		{
			$aPagination->SetPageCount( $nPageCount ) ;
		}
		
		// reset inner iter
		$this->ResetInnerIterator() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aRecordSet			JCAT_DBRecordSet
	 * @param	$aORM				JCAT_ORM
	 * @param	$aChildModel		JCAT_IModel
	 * @return	void
	 */
	public function OnLoadChild(JCAT_DBRecordSet $aRecordSet,JCAT_ORM $aORM,JCAT_IModel $aChildModel)
	{
		// load child model
		$aORM->LoadModelByRules($aChildModel,$aRecordSet) ;
		
		// set child model statue 
		$aChildModel->SetSerialized() ;
		$aChildModel->SetChanged(false) ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	void
	 */
	private function OperationForChild($sOperation,array $arrArgs)
	{
		$aIterator = $this->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aChildModel = $aIterator->Current() ;
			call_user_func_array( array($aChildModel,$sOperation), $arrArgs ) ;
		}
	}
	
	public function Save( $bIgnoreChanged=false )
	{
		$this->OperationForChild('Save',array($bIgnoreChanged)) ;	
	}
	
	public function Delete()
	{
		$this->OperationForChild('Delete',array()) ;
	}
	
	public function Create()
	{
		$this->OperationForChild('Create',array()) ;	
	}

	/**
	 * set a find by a property
	 *
	 * @access	public
	 * @param 	$sDataName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindBy($sDataName,$Value,$sOperator='=',$sRightB=null)
	{
		$sFieldName = $this->GetORM()->GetFieldByProperty($sDataName) ;
		$this->arrQueryConditions[] = array($sFieldName?$sFieldName:$sDataName,$Value,$sOperator,$sRightB) ;
	}
	
	/**
	 * set a find condition
	 *
	 * @access	public
	 * @param 	$sFieldName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindByField($sFieldName,$Value,$sOperator='=',$sRightB=null)
	{
		$this->arrQueryConditions[] = array($sFieldName,$Value,$sOperator,$sRightB) ;
	}
	
	/**
	 * 设置查询条件
	 *
	 * @access	public
	 * @param	$sCondition		string
	 * @return	void
	 */
	public function FindByCondition($sCondition)
	{
		$this->arrQueryConditions[] = $sCondition ;
	}
	
	/**
	 * 设置关键词
	 *
	 * @access	public
	 * @param	$sKeywords			string
	 * @return	void
	 */
	public function FindByKeywords($sKeywords,$arrClmNames)
	{
		/*$aPrototype = $this->GetChildModelPrototype() ;
		$aWhere = $aPrototype->GetSubSQLWhere() ;
		$aFactory = $aWhere->GetFactory() ;
		$aGroup = $aWhere->AddGroup(false) ;

		foreach ($arrClmNames as $sClmName)
		{
			$aCondition = $aFactory->CreateSubSQLCondition(
								$aGroup
								, $aFactory->CreateColumn($sClmName)
								, "%{$sKeywords}%"
								, 'LIKE' ) ;
			$aGroup->AddCondition($aCondition) ;
		}*/
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName			string
	 * @param	$bDesc=true			bool
	 * @return	void
	 */
	public function FindSort($sDataName,$bDesc=true)
	{
		$this->GetORM()->AddOrderBy($sDataName,$bDesc);
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateConditionIterator()
	{
		return new JCAT_ArrayIterator($this->arrQueryConditions) ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $Prototype ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_ORM
	 */
	private $aORM ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrQueryConditions = array() ;
}



?>