<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBModel.php 1855 2009-05-20 17:33:15Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

define('JCATPATH_MODEL_DB',JCATPATH.'Lib.php/MVC/Model/DBModel/') ;

// load orm package
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORM.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORM_Action.php' ;

include_once JCATPATH_MODEL_DB.'ORM/interface.JCAT_IORMRule.php' ;
include_once JCATPATH_MODEL_DB.'ORM/interface.JCAT_IORMRule_FieldsToProperties.php' ;
include_once JCATPATH_MODEL_DB.'ORM/interface.JCAT_IORMRule_TableLink.php' ;
include_once JCATPATH_MODEL_DB.'ORM/interface.JCAT_IORMRule_TLMultipleAssociation.php' ;
include_once JCATPATH_MODEL_DB.'ORM/interface.JCAT_IORMRule_TLSingleAssociation.php' ;

include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRuleBase.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_FieldsToProperties.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TableLinkBase.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TLHasOne.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TLBelongsTo.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TLMultipleBase.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TLHasMany.php' ;
include_once JCATPATH_MODEL_DB.'ORM/class.JCAT_ORMRule_TLHasAndBelongsToMany.php' ;




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBModel extends JCAT_Model implements JCAT_IDBModel
{
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrORMConf=array()		array				What's this Parameter ?
	 * @param	$aDB=null					JCAT_DB			What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_DBModel( $ORMOrConfig=array(), JCAT_DB $aDB=null )
	{
		$this->JCAT_Model() ;
	
		if( is_array($ORMOrConfig) )
		{
			// create orm
			$aORM = new JCAT_ORM($aDB) ;
			$aORM->InitFromConfig($ORMOrConfig) ;
			$this->SetORM($aORM) ;
		}
		
		else if (JCAT_Global::IsKindOf($ORMOrConfig,'JCAT_ORM') )
		{
			$this->SetORM($ORMOrConfig) ;
		}
		
		else
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'参数 $ORMOrConfig 必须为 ORM Config 数组 或 ORM 对象'
				, 'JCAT', null
			)) ;
		}
		
		// 创建对象结构
		$aORM = $this->GetORM() ;
		$aORM->Construct($this) ;
	}

	/**
	 * create a db aggregation model by passing a ORM
	 *
	 * @access	public
	 * @param	$aORM			JCAT_ORM
	 * @static
	 * @return	JCAT_DBModel
	 */
	static public function CreateByORM(JCAT_ORM $aORM)
	{
		return new self($aORM) ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __sleep()
	{
		$arrSavePropertys = parent::__sleep() ;
		
		$arrSavePropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('aORM',__CLASS__) ;
		
		return $arrSavePropertys ;
	}

	
	/**
	 * set ORM
	 *
	 * @access	public
	 * @param 	$aORM		JCAT_ORM
	 * @return	void
	 */
	public function SetORM(JCAT_ORM $aORM)
	{
		$this->aORM = $aORM ;
	}
	
	/**
	 * get ORM
	 *
	 * @access	public
	 * @return	JCAT_ORM
	 */
	public function GetORM()
	{
		return $this->aORM ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$sDataName		string
	 * @return	array(JCAT_IDBModel,string)
	 */
	protected function LocateData($sDataName)
	{
		if( $this->IsDataExists( $sDataName ) )
		{
			return array($this,$sDataName) ;
		}
		
		// from child model
		else 
		{
			// 根据 "." 路径命名定位
			// -----------------------
			$arrPath = explode('.',$sDataName) ;
			if( count($arrPath)>1 )
			{
				$aChildModel = null ;
				$aActiveModel = $this ;
				while( $sPathNode = array_shift($arrPath) )
				{
					$aChildModel = $aActiveModel->GetModel($sPathNode) ;
					if(!$aChildModel)
					{
						break ;
					}
					
					// 最后一级
					if(count($arrPath)==1)
					{
						$sActiveDataName = array_shift($arrPath) ;
						if( $aChildModel->IsDataExists($sActiveDataName) )
						{
							return array($aChildModel,$sActiveDataName) ;
						}
					}
					
					// 继续深入
					else 
					{
						$aActiveModel = $aChildModel ; 
					}
				}
			}
			
			// 在子文档中找同名的数据
			// -----------------------
			$aIterator = $this->GetORM()->CreateORMRuleIterator(JCAT_ORM::RULE_TL_SINGLE) ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$aORMRule = $aIterator->Current() ;
				$aChildModel = $aORMRule->GetAssocateWith($this) ;
				
				if( $aChildModel and $aChildModel->IsDataExists($sDataName) )
				{
					return array($aChildModel,$sDataName) ;
				}
			}	
			
			
			return array(null,null) ;
		}
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName			string	What's this Parameter ?
	 * @param	$Value				mixed	What's this Parameter ?
	 * @param	$bSetChanged=true	bool	What's this Parameter ?
	 * @return	old_var
	 */
	public function Set( $sInDataName, $Value, $bSetChanged=true, $bPassToChild=true )
	{
		JCAT_ASSERT::ASSERT_STRING($sInDataName) ;
		
		if($bPassToChild)
		{
			list($aModel,$sDataName) = $this->LocateData($sInDataName) ;
			if( $aModel===$this or !$aModel or $sDataName===null )
			{
				return parent::Set(($sDataName?$sDataName:$sInDataName),$Value,$bSetChanged) ;
			}
			
			else 
			{
				return $aModel->Set($sDataName,$Value,$bSetChanged) ;
			}
		}
		
		else
		{
			return parent::Set($sInDataName,$Value,$bSetChanged) ;
		}
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName	string	What's this Parameter ?
	 * @return	mixed, null
	 */
	public function Get( $sInDataName )
	{
		JCAT_ASSERT::ASSERT_STRING($sInDataName) ;
		
		if( $this->IsDataExists($sInDataName) )
		{
			return parent::Get($sInDataName) ;
		}
		
		else 
		{
			list($aModel,$sDataName) = $this->LocateData($sInDataName) ;
			if( $aModel and $sDataName )
			{
				return $aModel->Get($sDataName) ;
			}
		}
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sFieldName	string	What's this Parameter ?
	 * @return	
	 */
	public function GetByField( $sFieldName )
	{
		$sDataName = $this->GetORM()->GetPropertyByField($sFieldName) ;
		return $this->Get($sDataName) ;
	}

	/**
	 * get db primary key
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPrimaryKey()
	{
		$aORM = $this->GetORM() ;
		JCAT_ASSERT::ASSERT_NOTNULL($aORM,JCAT_Language::SentenceEx('no ORM ?','JCAT',null))  ;
		
		return $aORM->GetPrimaryKey() ;
	}
	
	/**
	 * get the primary key value
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetId()
	{
		$sPrimaryKeyName = $this->GetPrimaryKey() ;
		return $sPrimaryKeyName? $this->Get($sPrimaryKeyName): null ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	function Create()
	{
		$aORM = $this->GetORM() ;
		if(!$aORM)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'模型缺少 ORM，无法完成操作：%s::%s()；可能你的派生模型没有调用父类(%s)的构造函数来完成初始化。'
				, 'JCAT', null, get_class($this), __FUNCTION__, __CLASS__
			)) ;			
		}

		if( !$aORM->Create($this) )
		{
			return false ;
		}
		
		else 
		{
			return parent::Create() ;
		}
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Load()
	{
		$aORM = $this->GetORM() ;
		if(!$aORM)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'模型缺少 ORM，无法完成操作：%s::%s()；可能你的派生模型没有调用父类(%s)的构造函数来完成初始化。'
				, 'JCAT', null, get_class($this), __FUNCTION__, __CLASS__
			)) ;			
		}
		
		if( !$aORM->Load($this) )
		{
			return false ;
		}
		
		else 
		{
			return parent::Load() ;
		}
	}

	/**
	 * 保存记录，如果 IsChanged() 返回false 且 $bIgnoreChanged＝false ,不会实际执行操作。
	 * 返回值仅代表 是否 实际执行操作，如果操作失败，抛出异常
	 * 
	 * @access	public
	 * @param	$bIgnoreChanged=false	bool	是否忽略 bChange
	 * @return	bool
	 */
	public function Save( $bIgnoreChanged=false )
	{
		if( !$this->IsChanged() and !$bIgnoreChanged )
		{
			return true ;
		}
	
		$aORM = $this->GetORM() ;
		if(!$aORM)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'模型缺少 ORM，无法完成操作：%s::%s()；可能你的派生模型没有调用父类(%s)的构造函数来完成初始化。'
				, 'JCAT', null, get_class($this), __FUNCTION__, __CLASS__
			)) ;			
		}
		
		if( !$aORM->Save($this) )
		{
			return false ;
		}
		
		else 
		{
			return parent::Save() ;
		}
	}
	
	
	/**
	 * 删除模型
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Delete()
	{
	
		$aORM = $this->GetORM() ;
		if(!$aORM)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'模型缺少 ORM，无法完成操作：%s::%s()；可能你的派生模型没有调用父类(%s)的构造函数来完成初始化。'
				, 'JCAT', null, get_class($this), __FUNCTION__, __CLASS__
			)) ;			
		}
		
		if( !$aORM->Delete($this) )
		{
			return false ;
		}
		
		else 
		{
			return parent::Delete() ;
		}
	}


	/**
	 * set a find by a property
	 *
	 * @access	public
	 * @param 	$sDataName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindBy($sDataName,$Value,$sOperator='=',$sRightB=null)
	{
		$sFieldName = $this->GetORM()->GetFieldByProperty($sDataName) ;
		$this->arrQueryConditions[] = array($sFieldName?$sFieldName:$sDataName,$Value,$sOperator,$sRightB) ;
	}
	
	/**
	 * set a find condition
	 *
	 * @access	public
	 * @param 	$sFieldName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindByField($sFieldName,$Value,$sOperator='=',$sRightB=null)
	{
		$this->arrQueryConditions[] = array($sFieldName,$Value,$sOperator,$sRightB) ;
	}
	
	/**
	 * find row by primary key
	 *
	 * @access	public
	 * @param 	$sId		int, string
	 * @return	void
	 */
	public function FindById($sId)
	{
		$sPrimaryKey = $this->GetPrimaryKey() ;
		JCAT_ASSERT::ASSERT_NOTNULL($sPrimaryKey,JCAT_Language::SentenceEx('ORM中没有数据表的主键设置。','JCAT',null)) ;
		$this->FindBy($sPrimaryKey,$sId) ;
	}

	/**
	 * 设置查询条件
	 *
	 * @access	public
	 * @param	$sCondition		string
	 * @return	void
	 */
	public function FindByCondition($sCondition)
	{
		$this->arrQueryConditions[] = $sCondition ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName		string
	 * @param	$sDesc=true		bool
	 * @return	void
	 */
	public function FindSort($sDataName,$sDesc=true)
	{
		$this->GetORM()->AddOrderBy($sDataName,$sDesc) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateConditionIterator()
	{
		return new JCAT_ArrayIterator($this->arrQueryConditions) ;
	}
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_ORM
	 */
	private $aORM ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrQueryConditions = array() ;
}
?>