<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * a category model ,implements by db 
 *
 * @access public
 */
interface JCAT_IAdjacensyCategory
{
	
	/**
	 * 位置内
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_IN = 1 ;
	/**
	 * 位置外
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_OUT = 2 ;
	/**
	 * 位置前
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_FRONT = 4 ;
	/**
	 * 位置后
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_BEHIND = 8 ;
	/**
	 * 位置前后
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_BROTHER = 12 ;	
	/**
	 * 同一位置
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_SAME = 16 ;
	/**
	 * 无效的位置
	 * 
	 * @access	const
	 * @var		int
	 */
	const LOCAL_INVALID = 0 ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aAdjacensyCategory		JCAT_IAdjacensyCategory
	 * @return	void
	 */
	public function AddCategory(JCAT_IAdjacensyCategory $aInCategory) ;
	
	
	/**
	 * 递归地移除一个分类。 如果存在，删除并返回 true
	 *
	 * @access	public
	 * @param 	$aCategory		JCAT_IAdjacensyCategory
	 * @return	bool
	 */
	public function RemoveCategory(JCAT_IAdjacensyCategory $aCategory) ;
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetBrother(JCAT_IAdjacensyCategory $aBrother=null,$nPos=self::LOCAL_FRONT) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IAdjacensyCategory
	 */
	public function GetBrother($nPos=self::LOCAL_FRONT) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetBrothers() ;
	
	/**
	 * 设置对象属性 self::$aParentCategory
	 *
	 * @access	public
	 * @param	$aParentCategory=null		JCAT_IAdjacensyCategory	上级分类
	 * @return	void
	 */
	public function SetParent(JCAT_IAdjacensyCategory $aParentCategory=null) ;
	
	/**
	 * 取得对象属性 self::$aParentCategory
	 *
	 * @access	public
	 * @return	JCAT_IAdjacensyCategory
	 */
	public function GetParent() ;
	
	/**
	 * 指定一个分类的id，返回这个分类的所属路径
	 *
	 * @access	public
	 * @param	$nTargetCategoryId
	 * @return	array
	 */
	public function GetCategoryPath() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nTreeDepth		int
	 * @return	void
	 */
	public function SetTreeDepth($nTreeDepth) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetTreeDepth() ;
	
	/**
	 * get child categories count
	 *
	 * @access	public
	 * @param	$bRecursion=true	bool
	 * @return	int
	 */
	public function GetChildrenCount($bRecursion=true) ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateChildCategoryIter() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bDecoupling=true	bool	是否解除关系
	 * @return	void
	 */
	public function ClearChildren($bDecoupling=true) ;
	
	
	/**
	 * 比较位置
	 *
	 * @access	public
	 * @param	$aWith	JCAT_IAdjacensyCategory
	 * @return	void
	 */
	public function Compare(JCAT_IAdjacensyCategory $aCategory) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetAdjacWidth() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetLeftBorder() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetRightBorder() ;
	
	/**
	 * 取得分类的名字
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetText() ;

}


?>